/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.gp;

import java.util.Iterator;
import java.util.Random;
import org.mov.analyser.GPGondolaSelection;
import org.mov.parser.Expression;
import org.mov.parser.expression.AbsExpression;
import org.mov.parser.expression.AddExpression;
import org.mov.parser.expression.AndExpression;
import org.mov.parser.expression.AvgExpression;
import org.mov.parser.expression.DayExpression;
import org.mov.parser.expression.DayOfWeekExpression;
import org.mov.parser.expression.DayOfYearExpression;
import org.mov.parser.expression.DivideExpression;
import org.mov.parser.expression.EqualThanExpression;
import org.mov.parser.expression.GetVariableExpression;
import org.mov.parser.expression.GreaterThanEqualExpression;
import org.mov.parser.expression.GreaterThanExpression;
import org.mov.parser.expression.IfExpression;
import org.mov.parser.expression.LagExpression;
import org.mov.parser.expression.LessThanEqualExpression;
import org.mov.parser.expression.LessThanExpression;
import org.mov.parser.expression.MaxExpression;
import org.mov.parser.expression.MinExpression;
import org.mov.parser.expression.MonthExpression;
import org.mov.parser.expression.MultiplyExpression;
import org.mov.parser.expression.NotEqualExpression;
import org.mov.parser.expression.NotExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.parser.expression.OrExpression;
import org.mov.parser.expression.PercentExpression;
import org.mov.parser.expression.QuoteExpression;
import org.mov.parser.expression.RSIExpression;
import org.mov.parser.expression.SqrtExpression;
import org.mov.parser.expression.SubtractExpression;
import org.mov.parser.expression.SumExpression;

public class Mutator {
    private static final int BRANCH_FACTOR = 80;
    private static final int FAVOUR_NUMBER_PERCENT = 85;
    private static final int MUTATION_PERCENT = 10;
    private static final int EXTRA_MUTATION_PERCENT = 10;
    private static final int INSERTION_MUTATION_PERCENT = 10;
    private static final int DELETION_MUTATION_PERCENT = 20;
    private static final int MODIFICATION_MUTATION_PERCENT = 70;
    private Random random;
    private GPGondolaSelection GPGondolaSelection;
    private boolean allowHeld;
    private boolean allowOrder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Mutator(Random random, GPGondolaSelection GPGondolaSelection2, boolean allowHeld, boolean allowOrder) {
        this.random = random;
        this.GPGondolaSelection = GPGondolaSelection2;
        this.allowHeld = allowHeld;
        this.allowOrder = allowOrder;
    }

    public Expression createRandom(int type) {
        return this.createRandom(null, type, 1);
    }

    public Expression createRandom(int type, int level) {
        return this.createRandom(null, type, level);
    }

    public Expression createRandom(Expression model, int type, int level) {
        boolean terminal = true;
        if (level < 1) {
            terminal = false;
        } else {
            double branchPercent = 80.0 / (double)level;
            double percent = this.random.nextDouble() * 100.0;
            if (branchPercent > percent) {
                terminal = false;
            }
        }
        if (type == 0 || !terminal) {
            return this.createRandomNonTerminal(model, type, level + 1);
        }
        return this.createRandomTerminal(type);
    }

    public Expression createRandomNonTerminal(int type) {
        return this.createRandomNonTerminal(null, type, 1);
    }

    public Expression createRandomNonTerminal(int type, int level) {
        return this.createRandomNonTerminal(null, type, level);
    }

    public Expression createRandomNonTerminal(Expression model, int type, int level) {
        if (type == 0) {
            return this.createRandomNonTerminalBoolean(model, level);
        }
        if (type == 1) {
            return this.createRandomNonTerminalFloat(model, level);
        }
        if (type == 2) {
            return this.createRandomNonTerminalInteger(model, level);
        }
        if (!$assertionsDisabled && type != 3 && type != 4) {
            throw new AssertionError();
        }
        return this.createRandomTerminal(type);
    }

    public Expression createRandomTerminal(int type) {
        switch (type) {
            case 0: {
                int randomNumber = this.random.nextInt(2);
                if (randomNumber == 0) {
                    return new NumberExpression(true);
                }
                if (!$assertionsDisabled && randomNumber != 1) {
                    throw new AssertionError();
                }
                return new NumberExpression(false);
            }
            case 1: {
                return new NumberExpression(50.0 - this.random.nextDouble() * 100.0);
            }
            case 2: {
                int randomNumber = this.GPGondolaSelection.getRandomToGenerateInteger(this.allowHeld, this.allowOrder);
                if (randomNumber == 0) {
                    return new NumberExpression(50 - this.random.nextInt(100));
                }
                if (randomNumber == 1) {
                    return new DayOfYearExpression();
                }
                if (randomNumber == 2) {
                    return new MonthExpression();
                }
                if (randomNumber == 3) {
                    return new DayExpression();
                }
                if (randomNumber == 4) {
                    return new DayOfWeekExpression();
                }
                if (this.allowOrder && this.allowHeld) {
                    if (randomNumber == 5) {
                        return new GetVariableExpression("held", 2);
                    }
                    return new GetVariableExpression("order", 2);
                }
                if (this.allowHeld) {
                    return new GetVariableExpression("held", 2);
                }
                if (!$assertionsDisabled && !this.allowOrder) {
                    throw new AssertionError();
                }
                return new GetVariableExpression("order", 2);
            }
            case 3: {
                int randomNumber = this.GPGondolaSelection.getRandomToGenerateFloatQuote();
                if (randomNumber == 0) {
                    return new QuoteExpression(1);
                }
                if (randomNumber == 1) {
                    return new QuoteExpression(3);
                }
                if (randomNumber == 2) {
                    return new QuoteExpression(2);
                }
                if (!$assertionsDisabled && randomNumber != 3) {
                    throw new AssertionError();
                }
                return new QuoteExpression(0);
            }
            case 4: {
                return new QuoteExpression(4);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private Expression createRandomNonTerminalBoolean(Expression model, int level) {
        int randomNumber = this.GPGondolaSelection.getRandomToGenerateBoolean();
        if (randomNumber == 0) {
            return new NotExpression(this.getChild(model, level, 0, 0));
        }
        if (randomNumber == 1) {
            Expression first = this.getChild(model, level, 0);
            return new EqualThanExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 2) {
            Expression first = this.getChild(model, level, 0);
            return new GreaterThanEqualExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 3) {
            Expression first = this.getChild(model, level, 0);
            return new GreaterThanExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 4) {
            Expression first = this.getChild(model, level, 0);
            return new LessThanEqualExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 5) {
            Expression first = this.getChild(model, level, 0);
            return new LessThanExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 6) {
            Expression first = this.getChild(model, level, 0);
            return new NotEqualExpression(first, this.getChild(model, level, 1, first.getType()));
        }
        if (randomNumber == 7) {
            return new AndExpression(this.getChild(model, level, 0, 0), this.getChild(model, level, 1, 0));
        }
        if (!$assertionsDisabled && randomNumber != 8) {
            throw new AssertionError();
        }
        return new OrExpression(this.getChild(model, level, 0, 0), this.getChild(model, level, 1, 0));
    }

    private Expression createRandomNonTerminalFloat(Expression model, int level) {
        if (model != null && model instanceof NumberExpression && 85 > this.random.nextInt(100)) {
            NumberExpression numberExpression = (NumberExpression)model;
            double step = this.random.nextDouble() * 6.0;
            double value = Math.pow(10.0, step);
            if (this.random.nextBoolean()) {
                value = -value;
            }
            numberExpression.setValue(numberExpression.getValue() + value);
            return numberExpression;
        }
        int randomNumber = this.GPGondolaSelection.getRandomToGenerateExpression();
        if (randomNumber == 0) {
            return this.createRandomTerminal(1);
        }
        if (randomNumber == 1) {
            return new AddExpression(this.getChild(model, level, 0, 1), this.getChild(model, level, 1, 1));
        }
        if (randomNumber == 2) {
            return new SubtractExpression(this.getChild(model, level, 0, 1), this.getChild(model, level, 1, 1));
        }
        if (randomNumber == 3) {
            return new MultiplyExpression(this.getChild(model, level, 0, 1), this.getChild(model, level, 1, 1));
        }
        if (randomNumber == 4) {
            return new DivideExpression(this.getChild(model, level, 0, 1), this.getChild(model, level, 1, 1));
        }
        if (randomNumber == 5) {
            return new PercentExpression(this.getChild(model, level, 0, 1), this.getChild(model, level, 1));
        }
        if (randomNumber == 6) {
            return new IfExpression(this.getChild(model, level, 0, 0), this.getChild(model, level, 1, 1), this.getChild(model, level, 2, 1));
        }
        if (randomNumber == 7) {
            return new LagExpression(this.createRandomTerminal(3), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 8) {
            return new MinExpression(this.createRandomTerminal(3), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 9) {
            return new MaxExpression(this.createRandomTerminal(3), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 10) {
            return new SumExpression(this.createRandomTerminal(3), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 11) {
            return new SqrtExpression(this.getChild(model, level, 0, 1));
        }
        if (randomNumber == 12) {
            return new AbsExpression(this.getChild(model, level, 0, 1));
        }
        if (randomNumber == 13) {
            return new RSIExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1, 2));
        }
        if (!$assertionsDisabled && randomNumber != 14) {
            throw new AssertionError();
        }
        return new AvgExpression(this.createRandomTerminal(3), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
    }

    private Expression createRandomNonTerminalInteger(Expression model, int level) {
        if (model != null && model instanceof NumberExpression && 85 > this.random.nextInt(100)) {
            NumberExpression numberExpression = (NumberExpression)model;
            double step = this.random.nextDouble() * 6.0;
            double value = Math.pow(10.0, step);
            if (this.random.nextBoolean()) {
                value = -value;
            }
            numberExpression.setValue(numberExpression.getValue() + value);
            return numberExpression;
        }
        int randomNumber = 0;
        while ((randomNumber = this.GPGondolaSelection.getRandomToGenerateExpression()) == 13) {
        }
        if (randomNumber == 0) {
            return this.createRandomTerminal(2);
        }
        if (randomNumber == 1) {
            return new AddExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 2) {
            return new SubtractExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 3) {
            return new MultiplyExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 4) {
            return new DivideExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 5) {
            return new PercentExpression(this.getChild(model, level, 0, 2), this.getChild(model, level, 1));
        }
        if (randomNumber == 6) {
            return new IfExpression(this.getChild(model, level, 0, 0), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 7) {
            return new LagExpression(new QuoteExpression(4), this.getChild(model, level, 1, 2));
        }
        if (randomNumber == 8) {
            return new MinExpression(new QuoteExpression(4), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 9) {
            return new MaxExpression(new QuoteExpression(4), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 10) {
            return new SumExpression(new QuoteExpression(4), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
        }
        if (randomNumber == 11) {
            return new SqrtExpression(this.getChild(model, level, 0, 2));
        }
        if (randomNumber == 12) {
            return new AbsExpression(this.getChild(model, level, 0, 2));
        }
        if (!$assertionsDisabled && randomNumber != 14) {
            throw new AssertionError();
        }
        return new AvgExpression(new QuoteExpression(4), this.getChild(model, level, 1, 2), this.getChild(model, level, 2, 2));
    }

    private Expression getChild(Expression model, int level, int arg, int type) {
        if (model == null || arg >= model.getChildCount() || model.getChild(arg).getType() != type) {
            return this.createRandom(null, type, level);
        }
        return model.getChild(arg);
    }

    private Expression getChild(Expression model, int level, int arg) {
        if (model == null || arg >= model.getChildCount() || model.getChild(arg).getType() != 1 && model.getChild(arg).getType() != 2) {
            int randomNumber = this.GPGondolaSelection.getRandomToGenerateFloatInteger();
            if (randomNumber == 0) {
                return this.createRandom(null, 1, level);
            }
            if (!$assertionsDisabled && randomNumber != 1) {
                throw new AssertionError();
            }
            return this.createRandom(null, 2, level);
        }
        return model.getChild(arg);
    }

    public Expression findRandomSite(Expression expression) {
        int randomNumber = this.random.nextInt(expression.size());
        Expression randomSite = null;
        Iterator iterator = expression.iterator();
        while (iterator.hasNext()) {
            randomSite = (Expression)iterator.next();
            if (randomNumber-- > 0) continue;
        }
        if (!$assertionsDisabled && randomSite == null) {
            throw new AssertionError();
        }
        return randomSite;
    }

    public Expression findRandomSite(Expression expression, int type) {
        Expression randomSite = null;
        int possibleSites = expression.size(type);
        if (possibleSites > 0) {
            int randomNumber = this.random.nextInt(possibleSites);
            Iterator iterator = expression.iterator();
            while (iterator.hasNext() && ((randomSite = (Expression)iterator.next()).getType() != type || randomNumber-- > 0)) {
            }
            if (!$assertionsDisabled && randomSite == null) {
                throw new AssertionError();
            }
        }
        return randomSite;
    }

    public Expression delete(Expression root, Expression destination) {
        return this.insert(root, destination, this.createRandomTerminal(destination.getType()));
    }

    public Expression insert(Expression root, Expression destination, Expression source) {
        Expression parent = destination.getParent();
        if (parent == null) {
            if (!$assertionsDisabled && root != destination) {
                throw new AssertionError();
            }
            return source;
        }
        int childNumber = parent.getIndex(destination);
        parent.setChild(source, childNumber);
        return root;
    }

    public Expression modify(Expression root, Expression destination) {
        if (destination == root) {
            Expression newExpression = this.createRandom(destination.getType(), 1);
            newExpression = newExpression.simplify();
            return newExpression;
        }
        Expression newExpression = this.createRandom(destination, destination.getType(), 1);
        newExpression = newExpression.simplify();
        return this.insert(root, destination, newExpression);
    }

    public Expression mutate(Expression expression) {
        return this.mutate(expression, 10);
    }

    public Expression mutate(Expression expression, int percent) {
        int randomPercent = this.random.nextInt(100);
        if (percent < randomPercent) {
            return expression;
        }
        int randomTypePercent = this.random.nextInt(100);
        if (10 > randomTypePercent) {
            expression = this.mutateByInsertion(expression);
        } else if (20 > (randomTypePercent -= 10)) {
            expression = this.mutateByDeletion(expression);
        } else {
            randomTypePercent -= 20;
            expression = this.mutateByModification(expression);
        }
        return this.mutate(expression, 10);
    }

    private Expression mutateByModification(Expression expression) {
        Expression destination = this.findRandomSite(expression);
        return this.modify(expression, destination);
    }

    private Expression mutateByInsertion(Expression expression) {
        Expression destination = this.findRandomSite(expression);
        Expression insertSubTree = this.createRandom(destination.getType());
        return this.insert(expression, destination, insertSubTree);
    }

    private Expression mutateByDeletion(Expression expression) {
        Expression destination = this.findRandomSite(expression);
        if (destination.isRoot() || destination.getChildCount() == 0) {
            return this.mutateByModification(expression);
        }
        return this.delete(expression, destination);
    }

    static {
        $assertionsDisabled = !Mutator.class.desiredAssertionStatus();
    }
}

