/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.mov.chart.Chart;
import org.mov.chart.GraphTools;
import org.mov.chart.HorizontalAxis;
import org.mov.chart.VerticalAxis;
import org.mov.chart.graph.Graph;

public class BasicChartUI
extends ComponentUI
implements ImageObserver {
    private static final double TOP_GRAPH_BUFFER_MULTIPLIER = 1.5;
    private static final int X_LABEL_HEIGHT = 40;
    private static final int Y_LABEL_WIDTH = 60;
    private static final int MINIMUM_LEVEL_HEIGHT = 50;
    private static final int ANNOTATED_TEXT_MARGIN = 5;
    private static final int MINIMUM_TRADING_DAYS_IN_MONTH = 20;
    private static final int BUFFER_BUFFER_SIZE = 200;
    private static final int PRIMARY_HEIGHT_UNITS = 4;
    private static final int SECONDARY_HEIGHT_UNITS = 1;
    private double horizontalScale;
    private int firstHorizontalLine;
    private BufferedImage image = null;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private Vector levelHeights;
    private HorizontalAxis quartersHorizontalAxis = null;
    private HorizontalAxis monthsHorizontalAxis = null;
    private HorizontalAxis majorHorizontalAxis = null;
    private HorizontalAxis minorHorizontalAxis = null;
    private Vector verticalAxes = null;
    private HashMap colourMap = null;
    private int xoffset;
    private int yoffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int getMinimumWidth(Chart chart) {
        if (chart.getXRange() != null) {
            return chart.getXRange().size() + 60;
        }
        return 60;
    }

    public static int getMinimumHeight(Chart chart) {
        int levels = chart.getLevels().size();
        return 50 * levels + 40;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicChartUI();
    }

    public Comparable getXAtPoint(Chart chart, int xCoordinate) {
        Comparable x = null;
        int xOffset = (int)((double)xCoordinate / this.horizontalScale);
        if (xOffset >= chart.getXRange().size()) {
            xOffset = chart.getXRange().size() - 1;
        }
        if (xOffset < 0) {
            xOffset = 0;
        }
        if (chart.getXRange() != null && xOffset < chart.getXRange().size()) {
            x = (Comparable)chart.getXRange().elementAt(xOffset);
        }
        return x;
    }

    private int getLevelAtPoint(int yCoordinate) {
        Iterator iterator = this.levelHeights.iterator();
        int level = 0;
        int yoffset = 0;
        while (iterator.hasNext()) {
            if (yCoordinate <= (yoffset += ((Integer)iterator.next()).intValue())) {
                return level;
            }
            ++level;
        }
        return 0;
    }

    private int getStartOfLevel(int level) {
        int yoffset = 0;
        if (level > 0) {
            for (int i = 0; i < level - 1; ++i) {
                yoffset += ((Integer)this.levelHeights.elementAt(i)).intValue();
            }
        }
        return yoffset;
    }

    public String getToolTipText(Chart chart, int xCoordinate, int yCoordinate) {
        if (this.verticalAxes == null) {
            return null;
        }
        Insets insets = chart.getInsets();
        int height = chart.getHeight() - insets.top - insets.bottom;
        Comparable x = this.getXAtPoint(chart, xCoordinate);
        int level = this.getLevelAtPoint(yCoordinate);
        VerticalAxis verticalAxis = (VerticalAxis)this.verticalAxes.elementAt(level);
        int yoffset = this.getStartOfLevel(level) + this.firstHorizontalLine;
        String toolTipText = null;
        if (yCoordinate < height - 40 && verticalAxis != null && x != null) {
            Iterator iterator = ((Vector)chart.getLevels().elementAt(level)).iterator();
            while (iterator.hasNext() && toolTipText == null) {
                Graph graph = (Graph)iterator.next();
                toolTipText = graph.getToolTipText(x, yCoordinate, yoffset + verticalAxis.getHeightOfGraph(), verticalAxis.getScale(), verticalAxis.getBottomLineValue());
            }
        }
        return toolTipText;
    }

    public void paint(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        int width = c.getWidth() - insets.left - insets.right;
        int height = c.getHeight() - insets.top - insets.bottom;
        if (this.image == null || this.image.getWidth() < width || this.image.getHeight() < height || this.image.getWidth() > width + 400 || this.image.getHeight() > height + 400) {
            this.image = new BufferedImage(width + 200, height + 200, 5);
        }
        if (width != this.bufferWidth || height != this.bufferHeight) {
            this.bufferedPaint(this.image.getGraphics(), (Chart)c, width, height);
            this.bufferWidth = width;
            this.bufferHeight = height;
        }
        g.drawImage(this.image, 0, 0, this);
        this.highlightRegion(g, (Chart)c, height);
        this.drawLines(g, (Chart)c, height);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void bufferedPaint(Graphics g, Chart chart, int width, int height) {
        this.calculateHorizontalAxes(g, chart, width, height);
        this.drawBackground(g, chart, width, height);
        this.drawLevels(g, chart, width, height);
        this.drawHorizontalLabels(g, height);
        this.drawAnnotations(g, chart);
    }

    private void calculateHorizontalAxes(Graphics g, Chart chart, int width, int height) {
        if (!$assertionsDisabled && chart.getXRange().size() <= 0) {
            throw new AssertionError();
        }
        this.horizontalScale = HorizontalAxis.calculateScale(width - 60, chart.getXRange().size());
        String string = new String("Feb");
        if (this.horizontalScale * 20.0 < (double)(2 * g.getFontMetrics().stringWidth(string))) {
            if (this.quartersHorizontalAxis == null) {
                this.quartersHorizontalAxis = new HorizontalAxis(chart.getXRange(), 1, 1);
            }
            this.minorHorizontalAxis = this.quartersHorizontalAxis;
        } else {
            if (this.monthsHorizontalAxis == null) {
                this.monthsHorizontalAxis = new HorizontalAxis(chart.getXRange(), 2, 1);
            }
            this.minorHorizontalAxis = this.monthsHorizontalAxis;
        }
        if (this.majorHorizontalAxis == null) {
            this.majorHorizontalAxis = new HorizontalAxis(chart.getXRange(), 0, 0);
        }
    }

    private void highlightRegion(Graphics g, Chart chart, int height) {
        if (chart.getHighlightedStart() != null && chart.getHighlightedEnd() != null) {
            int start = this.getXCoordinate(chart, chart.getHighlightedStart());
            int end = this.getXCoordinate(chart, chart.getHighlightedEnd());
            g.setXORMode(Color.pink);
            g.fillRect(start < end ? start : end, 0, 1 + Math.abs(end - start), height);
            g.setPaintMode();
        }
    }

    private void drawLines(Graphics g, Chart chart, int height) {
        if (chart.getDrawnLineStartX() != null && chart.getDrawnLineStartY() != null && chart.getDrawnLineEndX() != null && chart.getDrawnLineEndY() != null) {
            Vector startXs = chart.getDrawnLineStartX();
            Vector startYs = chart.getDrawnLineStartY();
            Vector endXs = chart.getDrawnLineEndX();
            Vector endYs = chart.getDrawnLineEndY();
            for (int i = 0; i < endXs.size(); ++i) {
                int startX = (Integer)startXs.elementAt(i);
                int startY = (Integer)startYs.elementAt(i);
                int endX = (Integer)endXs.elementAt(i);
                int endY = (Integer)endYs.elementAt(i);
                Color prev = g.getColor();
                g.setColor(Color.MAGENTA);
                g.drawLine(startX, startY, endX, endY);
                g.setColor(prev);
            }
            g.setPaintMode();
        }
    }

    private int getXCoordinate(Chart chart, Comparable x) {
        int i = 0;
        if (chart.getXRange() != null) {
            Iterator iterator = chart.getXRange().iterator();
            Comparable thisX = null;
            while (iterator.hasNext()) {
                thisX = (Comparable)iterator.next();
                if (x.compareTo(thisX) <= 0) {
                    return (int)((double)i * this.horizontalScale);
                }
                ++i;
            }
        }
        return (int)((double)i * this.horizontalScale);
    }

    public void resetBuffer() {
        this.quartersHorizontalAxis = null;
        this.monthsHorizontalAxis = null;
        this.majorHorizontalAxis = null;
        this.verticalAxes = null;
        this.colourMap = null;
        this.image = null;
        this.bufferWidth = 0;
        this.bufferHeight = 0;
    }

    private void drawBackground(Graphics g, Chart chart, int width, int height) {
        g.setColor(chart.getBackground());
        g.fillRect(0, 0, width, height);
    }

    private void drawVerticalGridAndLabels(Graphics g, Graph firstGraph, String title, VerticalAxis verticalAxis, int yoffset, int width) {
        g.setColor(Color.lightGray);
        verticalAxis.drawGridAndLabels(g, firstGraph, title, 0, yoffset, width - 60);
    }

    private void drawLevels(Graphics g, Chart chart, int width, int height) {
        this.firstHorizontalLine = this.getFirstHorizontalLine(g);
        this.calculateLevelHeights(chart, height);
        Iterator iterator = chart.getLevels().iterator();
        int yoffset = this.firstHorizontalLine;
        int level = 0;
        while (iterator.hasNext()) {
            Vector graphs = (Vector)iterator.next();
            this.drawLevel(g, graphs, chart, yoffset, width, (Integer)this.levelHeights.elementAt(level) - this.firstHorizontalLine, level);
            yoffset += ((Integer)this.levelHeights.elementAt(level++)).intValue();
        }
    }

    private void drawLevel(Graphics g, Vector graphs, Chart chart, int yoffset, int width, int height, int level) {
        VerticalAxis verticalAxis = this.calculateVerticalAxis(chart, graphs, height, level);
        this.drawVerticalGridAndLabels(g, (Graph)graphs.firstElement(), this.getLevelTitle(graphs), verticalAxis, yoffset, width);
        this.drawGraphs(g, graphs, chart, verticalAxis, yoffset, width, height);
        this.drawHorizontalGrid(g, chart, verticalAxis, yoffset);
    }

    private String getLevelTitle(Vector graphs) {
        Vector<String> symbols = new Vector<String>();
        Iterator iterator = graphs.iterator();
        while (iterator.hasNext()) {
            String symbol = ((Graph)iterator.next()).getSourceName();
            Iterator symbolsIterator = symbols.iterator();
            boolean found = false;
            while (symbolsIterator.hasNext()) {
                if (symbol.compareTo((String)symbolsIterator.next()) != 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            symbols.add(symbol);
        }
        return new String("");
    }

    private VerticalAxis calculateVerticalAxis(Chart chart, Vector graphs, int height, int level) {
        Graph firstGraph = (Graph)graphs.firstElement();
        if (this.verticalAxes == null) {
            this.verticalAxes = new Vector();
        }
        while (this.verticalAxes.size() <= level) {
            this.verticalAxes.add(null);
        }
        VerticalAxis verticalAxis = (VerticalAxis)this.verticalAxes.elementAt(level);
        if (verticalAxis == null) {
            verticalAxis = new VerticalAxis(this.getLowestY(chart.getXRange(), graphs), this.getHighestY(chart.getXRange(), graphs), firstGraph.getAcceptableMinorDeltas(), firstGraph.getAcceptableMajorDeltas());
            this.verticalAxes.setElementAt(verticalAxis, level);
        }
        verticalAxis.setHeight(height);
        return verticalAxis;
    }

    private void drawGraphs(Graphics g, Vector graphs, Chart chart, VerticalAxis verticalAxis, int yoffset, int width, int height) {
        Iterator iterator = graphs.iterator();
        while (iterator.hasNext()) {
            Graph graph = (Graph)iterator.next();
            graph.render(g, this.getGraphColour(graph, chart), 0, yoffset + verticalAxis.getHeightOfGraph() + (height - verticalAxis.getHeightOfGraph()) / 2, this.horizontalScale, verticalAxis.getScale(), verticalAxis.getBottomLineValue(), chart.getXRange());
        }
    }

    private void drawHorizontalGrid(Graphics g, Chart chart, VerticalAxis verticalAxis, int yoffset) {
        g.setColor(Color.lightGray);
        this.minorHorizontalAxis.drawGrid(g, yoffset + verticalAxis.getHeightOfGraph(), this.horizontalScale, verticalAxis.getHeightOfGraph());
        this.majorHorizontalAxis.drawGrid(g, yoffset + verticalAxis.getHeightOfGraph(), this.horizontalScale, verticalAxis.getHeightOfGraph());
    }

    private void drawHorizontalLabels(Graphics g, int height) {
        g.setColor(Color.lightGray);
        this.minorHorizontalAxis.drawLabels(g, this.horizontalScale, 0, height - 40 + g.getFontMetrics().getHeight());
        this.majorHorizontalAxis.drawLabels(g, this.horizontalScale, 0, height - 40 + g.getFontMetrics().getHeight() * 2);
    }

    private void drawAnnotations(Graphics g, Chart chart) {
        Iterator iterator = chart.getLevels().iterator();
        int level = 0;
        while (iterator.hasNext()) {
            Iterator innerIterator = ((Vector)iterator.next()).iterator();
            int yoffset = this.getStartOfLevel(level) + this.firstHorizontalLine;
            VerticalAxis verticalAxis = (VerticalAxis)this.verticalAxes.elementAt(level++);
            while (innerIterator.hasNext()) {
                Graph graph = (Graph)innerIterator.next();
                HashMap annotations = null;
                if (annotations == null || !chart.isAnnotated(graph)) continue;
                this.drawGraphAnnotations(g, chart, graph, verticalAxis, yoffset, annotations);
            }
        }
    }

    private void drawGraphAnnotations(Graphics g, Chart chart, Graph graph, VerticalAxis verticalAxis, int yoffset, HashMap annotations) {
        Set xRange = annotations.keySet();
        Iterator iterator = xRange.iterator();
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (x.compareTo(chart.getStartX()) < 0 || x.compareTo(chart.getEndX()) > 0) continue;
            String text = (String)annotations.get(x);
            text = x.toString() + ": " + text;
            Double y = graph.getY(x);
            if (y == null) continue;
            int yCoordinate = yoffset + verticalAxis.getHeightOfGraph() - GraphTools.scaleAndFitPoint(y, verticalAxis.getBottomLineValue(), verticalAxis.getScale());
            this.drawAnnotation(g, text, this.getXCoordinate(chart, x), yCoordinate);
        }
    }

    private void drawAnnotation(Graphics g, String text, int x, int y) {
        int width = g.getFontMetrics().stringWidth(text) + 10;
        int height = g.getFontMetrics().getHeight();
        g.setColor(Color.yellow);
        g.fillRect(x, y, width, height);
        g.setColor(Color.black);
        g.drawString(text, x + 5, y + height - g.getFontMetrics().getDescent());
    }

    public boolean imageUpdate(Image image, int infofloags, int x, int y, int width, int height) {
        return true;
    }

    private double getLowestY(Vector x, Vector graphs) {
        Iterator iterator = graphs.iterator();
        double lowestY = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double y = ((Graph)iterator.next()).getLowestY(x);
            if (!(y < lowestY)) continue;
            lowestY = y;
        }
        return lowestY;
    }

    private double getHighestY(Vector x, Vector graphs) {
        Iterator iterator = graphs.iterator();
        double highestY = Double.NEGATIVE_INFINITY;
        while (iterator.hasNext()) {
            double y = ((Graph)iterator.next()).getHighestY(x);
            if (!(y > highestY)) continue;
            highestY = y;
        }
        return highestY;
    }

    private void calculateLevelHeights(Chart chart, int height) {
        int levels = chart.getLevels().size();
        int units = 4 + (levels - 1) * 1;
        int unitHeight = (height -= 40) / units;
        int secondaryLevelHeight = unitHeight * 1 < 50 ? 50 : unitHeight * 1;
        int primaryLevelHeight = height - secondaryLevelHeight * (levels - 1);
        this.levelHeights = new Vector();
        this.levelHeights.add(new Integer(primaryLevelHeight));
        while (--levels > 0) {
            this.levelHeights.add(new Integer(secondaryLevelHeight));
        }
    }

    private int getFirstHorizontalLine(Graphics g) {
        this.firstHorizontalLine = (int)(1.5 * (double)g.getFontMetrics().getHeight());
        return this.firstHorizontalLine;
    }

    private void calculateColourMap(Chart chart) {
        if (this.colourMap == null) {
            Color[] colours = new Color[]{Color.cyan.darker(), Color.blue.darker(), Color.magenta.darker(), Color.orange.darker(), Color.pink.darker(), Color.blue, Color.magenta, Color.orange, Color.pink, Color.cyan.darker().darker(), Color.blue.darker().darker(), Color.magenta.darker().darker(), Color.orange.darker().darker(), Color.pink.darker().darker(), Color.cyan.brighter(), Color.blue.brighter(), Color.magenta.brighter(), Color.orange.brighter(), Color.pink.brighter()};
            this.colourMap = new HashMap();
            Iterator levelsIterator = chart.getLevels().iterator();
            int coloursUsed = 0;
            while (levelsIterator.hasNext()) {
                Iterator graphsIterator = ((Vector)levelsIterator.next()).iterator();
                while (graphsIterator.hasNext()) {
                    Graph graph = (Graph)graphsIterator.next();
                    String symbol = graph.getSourceName();
                    if (this.colourMap.get(symbol) != null) continue;
                    this.colourMap.put(symbol, colours[coloursUsed++]);
                    if (coloursUsed < colours.length) continue;
                    coloursUsed = 0;
                }
            }
        }
    }

    public Color getGraphColour(Graph graph, Chart chart) {
        Color colour;
        if (this.colourMap == null) {
            this.calculateColourMap(chart);
        }
        if ((colour = (Color)this.colourMap.get(graph.getSourceName())) != null) {
            return colour;
        }
        return Color.darkGray;
    }

    static {
        $assertionsDisabled = !BasicChartUI.class.desiredAssertionStatus();
    }
}

