/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import org.mov.chart.BasicChartUI;
import org.mov.chart.graph.Graph;
import org.mov.util.Locale;

public class Chart
extends JComponent
implements MouseListener {
    private Vector levels = new Vector();
    private BasicChartUI gui;
    private boolean toolTipBeenUp = false;
    private Comparable startX;
    private Comparable endX;
    private Vector xRange;
    private Comparable startHighlightedX;
    private Comparable endHighlightedX;
    private Vector startDrawnLinesX;
    private Vector startDrawnLinesY;
    private Vector endDrawnLinesX;
    private Vector endDrawnLinesY;
    private boolean zoomedIn = false;
    private HashMap annotatedGraphs = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Chart() {
        this.setBackground(Color.white);
        this.setForeground(Color.gray);
        this.addMouseListener(this);
        this.updateUI();
        this.startDrawnLinesX = new Vector();
        this.startDrawnLinesY = new Vector();
        this.endDrawnLinesX = new Vector();
        this.endDrawnLinesY = new Vector();
    }

    private Vector getGraphXRangeIterators() {
        Vector graphXRangeIterators = new Vector();
        Iterator levelsIterator = this.levels.iterator();
        while (levelsIterator.hasNext()) {
            Iterator graphIterator = ((Vector)levelsIterator.next()).iterator();
            while (graphIterator.hasNext()) {
                Graph graph = (Graph)graphIterator.next();
                Set xRange = graph.getXRange();
                graphXRangeIterators.add(xRange.iterator());
            }
        }
        return graphXRangeIterators;
    }

    private void setXRange(Comparable startX, Comparable endX) {
        this.startX = startX;
        this.endX = endX;
        TreeSet<Comparable> xRangeSet = new TreeSet<Comparable>();
        Vector graphXRangeiterators = this.getGraphXRangeIterators();
        Iterator graphXRangeIterator = graphXRangeiterators.iterator();
        block0: while (graphXRangeIterator.hasNext()) {
            Iterator xRangeIterator = (Iterator)graphXRangeIterator.next();
            while (xRangeIterator.hasNext()) {
                Comparable x = (Comparable)xRangeIterator.next();
                if (x.compareTo(startX) < 0) continue;
                if (x.compareTo(endX) > 0) continue block0;
                if (xRangeSet.contains(x)) continue;
                xRangeSet.add(x);
            }
        }
        this.xRange = new Vector(xRangeSet);
    }

    public Vector getXRange() {
        return this.xRange;
    }

    public Comparable getStartX() {
        return this.startX;
    }

    public Comparable getEndX() {
        return this.endX;
    }

    private Comparable calculateStartX() {
        Iterator iterator = this.levels.iterator();
        Comparable startX = null;
        while (iterator.hasNext()) {
            Iterator innerIterator = ((Vector)iterator.next()).iterator();
            while (innerIterator.hasNext()) {
                Comparable x = ((Graph)innerIterator.next()).getStartX();
                if (startX != null && x.compareTo(startX) >= 0) continue;
                startX = x;
            }
        }
        return startX;
    }

    private Comparable calculateEndX() {
        Iterator iterator = this.levels.iterator();
        Comparable endX = null;
        while (iterator.hasNext()) {
            Iterator innerIterator = ((Vector)iterator.next()).iterator();
            while (innerIterator.hasNext()) {
                Comparable x = ((Graph)innerIterator.next()).getEndX();
                if (endX != null && x.compareTo(endX) <= 0) continue;
                endX = x;
            }
        }
        return endX;
    }

    public void handleAnnotation(Graph graph, boolean enabled) {
        if (enabled) {
            this.annotatedGraphs.put(graph, new Boolean(true));
        } else {
            this.annotatedGraphs.remove(graph);
        }
    }

    public boolean isAnnotated(Graph graph) {
        return this.annotatedGraphs.get(graph) != null;
    }

    public void add(Graph graph, int index) {
        if (!$assertionsDisabled && graph.getXRange().size() <= 0) {
            throw new AssertionError();
        }
        if (index >= this.levels.size()) {
            Vector<Graph> newGraphs = new Vector<Graph>();
            newGraphs.add(graph);
            this.levels.add(newGraphs);
        } else {
            Vector oldGraphs = (Vector)this.levels.elementAt(index);
            oldGraphs.add(graph);
        }
        if (!this.zoomedIn) {
            this.setXRange(this.calculateStartX(), this.calculateEndX());
        }
    }

    public int count() {
        Iterator iterator = this.levels.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Vector innerVector = (Vector)iterator.next();
            count += innerVector.size();
        }
        return count;
    }

    public void remove(Graph graph) {
        boolean found = false;
        Iterator iterator = this.levels.iterator();
        while (iterator.hasNext()) {
            Vector innerVector = (Vector)iterator.next();
            Iterator innerIterator = innerVector.iterator();
            while (innerIterator.hasNext()) {
                Graph traverse = (Graph)innerIterator.next();
                if (traverse != graph) continue;
                innerVector.removeElement(graph);
                if (innerVector.size() == 0) {
                    this.levels.remove(innerVector);
                    if (!this.zoomedIn) {
                        this.setXRange(this.calculateStartX(), this.calculateEndX());
                    }
                }
                return;
            }
        }
    }

    public Vector getLevels() {
        return this.levels;
    }

    public Color getGraphColour(Graph graph) {
        return this.gui.getGraphColour(graph, this);
    }

    public void setUI(BasicChartUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.gui = new BasicChartUI();
        this.setUI(this.gui);
        this.resetBuffer();
    }

    public Comparable getXAtPoint(int x) {
        return this.gui.getXAtPoint(this, x);
    }

    public boolean contains(int x, int y) {
        String text = this.gui.getToolTipText(this, x, y);
        if (text == null && !this.toolTipBeenUp) {
            text = Locale.getString("HOVER_CURSOR_NEAR_GRAPH");
        } else if (!this.toolTipBeenUp) {
            this.toolTipBeenUp = true;
        }
        this.setToolTipText(text);
        return super.contains(x, y);
    }

    private void setSize() {
        this.setMinimumSize(new Dimension(BasicChartUI.getMinimumWidth(this), BasicChartUI.getMinimumHeight(this)));
        this.setPreferredSize(new Dimension(BasicChartUI.getMinimumWidth(this), BasicChartUI.getMinimumHeight(this)));
    }

    public String getUIClassID() {
        return "ChartUI";
    }

    public void setHighlightedStart(Comparable x) {
        this.startHighlightedX = x;
        this.endHighlightedX = x;
        this.repaint();
    }

    public void setHighlightedEnd(Comparable x) {
        this.endHighlightedX = x;
        this.repaint();
    }

    public void setDrawnLineStart(Integer x, Integer y) {
        this.startDrawnLinesX.add(x);
        this.startDrawnLinesY.add(y);
        this.repaint();
    }

    public void setDrawnLineEnd(Integer x, Integer y, boolean newLine) {
        if (newLine) {
            this.endDrawnLinesX.add(x);
            this.endDrawnLinesY.add(y);
        } else {
            this.endDrawnLinesX.setElementAt(x, this.endDrawnLinesX.size() - 1);
            this.endDrawnLinesY.setElementAt(y, this.endDrawnLinesY.size() - 1);
        }
        this.repaint();
    }

    public void setErase(Integer x, Integer y) {
        boolean deleteCount = false;
        for (int i = 0; i < this.endDrawnLinesY.size(); ++i) {
            Integer valX = (Integer)this.endDrawnLinesX.elementAt(i);
            Integer valY = (Integer)this.endDrawnLinesY.elementAt(i);
            int diff1 = Math.abs(valX - x);
            int diff2 = Math.abs(valY - y);
            if (diff1 >= 5 || diff2 >= 5) continue;
            this.endDrawnLinesX.remove(i);
            this.endDrawnLinesY.remove(i);
            this.startDrawnLinesX.remove(i);
            this.startDrawnLinesY.remove(i);
            break;
        }
    }

    public Comparable getHighlightedStart() {
        return this.startHighlightedX;
    }

    public Comparable getHighlightedEnd() {
        return this.endHighlightedX;
    }

    public Vector getDrawnLineStartX() {
        return this.startDrawnLinesX;
    }

    public Vector getDrawnLineStartY() {
        return this.startDrawnLinesY;
    }

    public Vector getDrawnLineEndX() {
        return this.endDrawnLinesX;
    }

    public Vector getDrawnLineEndY() {
        return this.endDrawnLinesY;
    }

    public void clearHighlightedRegion() {
        this.startHighlightedX = null;
        this.endHighlightedX = null;
        this.repaint();
    }

    public void zoomToHighlightedRegion() {
        if (this.startHighlightedX.compareTo(this.endHighlightedX) > 0) {
            Comparable temp = this.startHighlightedX;
            this.startHighlightedX = this.endHighlightedX;
            this.endHighlightedX = temp;
        }
        this.setXRange(this.startHighlightedX, this.endHighlightedX);
        this.clearHighlightedRegion();
        this.zoomedIn = true;
        this.resetBuffer();
    }

    public void zoomToDefaultRegion() {
        this.setXRange(this.calculateStartX(), this.calculateEndX());
        this.zoomedIn = false;
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.gui != null) {
            this.gui.resetBuffer();
        }
        this.setSize();
    }

    public String getTitle() {
        Iterator levelIterator = this.levels.iterator();
        Vector<String> symbols = new Vector<String>();
        while (levelIterator.hasNext()) {
            Vector graphs = (Vector)levelIterator.next();
            Iterator graphIterator = graphs.iterator();
            while (graphIterator.hasNext()) {
                Graph graph = (Graph)graphIterator.next();
                symbols.addElement(graph.getSourceName());
            }
        }
        TreeSet<Object> sortedSet = new TreeSet<Object>(Collator.getInstance());
        sortedSet.addAll(symbols);
        String symbolListString = "";
        boolean firstSymbol = true;
        Iterator<Object> symbolIterator = sortedSet.iterator();
        while (symbolIterator.hasNext()) {
            String symbol = (String)symbolIterator.next();
            if (firstSymbol) {
                symbolListString = symbolListString.concat(" " + symbol);
                firstSymbol = false;
                continue;
            }
            symbolListString = symbolListString.concat(", " + symbol);
        }
        return Locale.getString("CHART_TITLE", symbolListString);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.toolTipBeenUp = false;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public BufferedImage getImage() {
        return this.gui.getImage();
    }

    static {
        $assertionsDisabled = !Chart.class.desiredAssertionStatus();
    }
}

