/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.mov.chart.Chart;
import org.mov.chart.MarketIndicatorChartMenu;
import org.mov.chart.PortfolioChartMenu;
import org.mov.chart.QuoteChartMenu;
import org.mov.chart.graph.Graph;
import org.mov.chart.graph.LineGraph;
import org.mov.chart.source.OHLCVQuoteGraphSource;
import org.mov.main.Module;
import org.mov.portfolio.Portfolio;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteRange;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.ui.SymbolListDialog;
import org.mov.util.Locale;

public class ChartModule
extends JPanel
implements Module,
MouseListener,
MouseMotionListener,
ActionListener {
    private static int TOOLBAR_GRAPHIC_SIZE;
    private PropertyChangeSupport propertySupport;
    private Chart chart;
    private JScrollPane scrollPane;
    private JMenuBar menuBar = new JMenuBar();
    private JButton defaultZoom = null;
    private JButton zoomIn = null;
    private JButton paintOnChart = null;
    private JButton eraseOnChart = null;
    private JMenuItem addMenuItem = null;
    private JMenuItem closeMenuItem = null;
    private boolean defaultZoomEnabled = false;
    private boolean previousDefaultZoomState = false;
    private boolean zoomInEnabled = false;
    private boolean inDrawMode = false;
    private boolean inEraseMode = false;
    private boolean newLine = false;
    private JDesktopPane desktop;
    private String frameIcon = "org/mov/images/TableIcon.gif";
    private String defaultZoomImage = "toolbarButtonGraphics/general/Zoom24.gif";
    private String zoomInImage = "toolbarButtonGraphics/general/ZoomIn24.gif";
    private String paintInImage = "toolbarButtonGraphics/general/Edit24.gif";
    private String eraseInImage = "toolbarButtonGraphics/general/Remove24.gif";
    private boolean indexChart = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChartModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.indexChart = false;
        this.propertySupport = new PropertyChangeSupport(this);
        this.chart = new Chart();
        this.chart.addMouseListener(this);
        this.chart.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.addFunctionToolBar();
        JMenu menu = new JMenu(Locale.getString("GRAPH"));
        this.addMenuItem = new JMenuItem(Locale.getString("ADD"));
        this.addMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.addMenuItem.addActionListener(this);
        menu.add(this.addMenuItem);
        menu.addSeparator();
        this.closeMenuItem = new JMenuItem(Locale.getString("CLOSE"));
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this.closeMenuItem.addActionListener(this);
        menu.add(this.closeMenuItem);
        this.menuBar.add(menu);
        this.scrollPane = new JScrollPane(this.chart);
        this.add((Component)this.scrollPane, "Center");
    }

    public ChartModule(JDesktopPane desktop, boolean indexChart) {
        this.desktop = desktop;
        this.indexChart = indexChart;
        this.propertySupport = new PropertyChangeSupport(this);
        this.chart = new Chart();
        this.chart.addMouseListener(this);
        this.chart.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.addFunctionToolBar();
        JMenu menu = new JMenu(Locale.getString("GRAPH"));
        this.addMenuItem = new JMenuItem(Locale.getString("ADD"));
        this.addMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.addMenuItem.addActionListener(this);
        menu.add(this.addMenuItem);
        menu.addSeparator();
        this.closeMenuItem = new JMenuItem(Locale.getString("CLOSE"));
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this.closeMenuItem.addActionListener(this);
        menu.add(this.closeMenuItem);
        this.menuBar.add(menu);
        this.scrollPane = new JScrollPane(this.chart);
        this.add((Component)this.scrollPane, "Center");
    }

    private void addFunctionToolBar() {
        URL defaultZoomURL = ClassLoader.getSystemResource(this.defaultZoomImage);
        URL zoomInImageURL = ClassLoader.getSystemResource(this.zoomInImage);
        URL paintInImageURL = ClassLoader.getSystemResource(this.paintInImage);
        URL eraseInImageURL = ClassLoader.getSystemResource(this.eraseInImage);
        if (defaultZoomURL != null && zoomInImageURL != null) {
            JToolBar toolBar = new JToolBar(1);
            ImageIcon defaultZoomImageIcon = new ImageIcon(defaultZoomURL);
            this.defaultZoom = new JButton(defaultZoomImageIcon);
            this.defaultZoom.addActionListener(this);
            this.defaultZoom.setEnabled(this.defaultZoomEnabled);
            toolBar.add(this.defaultZoom);
            ImageIcon zoomInImageIcon = new ImageIcon(zoomInImageURL);
            this.zoomIn = new JButton(zoomInImageIcon);
            this.zoomIn.addActionListener(this);
            this.zoomIn.setEnabled(this.zoomInEnabled);
            toolBar.add(this.zoomIn);
            this.add((Component)toolBar, "West");
        }
    }

    public void redraw() {
        this.chart.resetBuffer();
        this.chart.validate();
        this.chart.repaint();
    }

    private void addMenu(JMenu menu) {
        int menus = this.menuBar.getMenuCount();
        boolean menuBarInserted = false;
        for (int i = 1; i < menus; ++i) {
            JMenu currentMenu = this.menuBar.getMenu(i);
            if (menu.getText().compareTo(currentMenu.getText()) > 0) continue;
            this.menuBar.add((Component)menu, i);
            menuBarInserted = true;
            break;
        }
        if (!menuBarInserted) {
            this.menuBar.add(menu);
        }
        this.propertySupport.firePropertyChange("titlebar changed", 0, 1);
    }

    public void add(Graph graph, Symbol symbol, QuoteBundle quoteBundle, int level) {
        if (!$assertionsDisabled && graph.getXRange().size() <= 0) {
            throw new AssertionError();
        }
        this.chart.add(graph, level);
        QuoteChartMenu menu = new QuoteChartMenu(this, quoteBundle, symbol, graph, this.indexChart);
        this.addMenu(menu);
    }

    public void add(SortedSet symbols) {
        Iterator iterator = symbols.iterator();
        Thread thread2 = Thread.currentThread();
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        ScriptQuoteBundle quoteBundle = null;
        LineGraph graph = null;
        OHLCVQuoteGraphSource dayClose = null;
        while (iterator.hasNext()) {
            final Symbol symbol = (Symbol)iterator.next();
            progress.show(Locale.getString("LOADING_QUOTES_FOR", symbol.toString()));
            if (!thread2.isInterrupted()) {
                quoteBundle = new ScriptQuoteBundle(new QuoteRange(symbol));
            }
            if (!thread2.isInterrupted()) {
                dayClose = new OHLCVQuoteGraphSource(quoteBundle, 0);
            }
            if (!thread2.isInterrupted()) {
                graph = new LineGraph(dayClose, Locale.getString("DAY_CLOSE"), true);
            }
            if (thread2.isInterrupted()) continue;
            final LineGraph finalGraph = graph;
            final ScriptQuoteBundle finalQuoteBundle = quoteBundle;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChartModule.this.add(finalGraph, symbol, finalQuoteBundle, 0);
                    ChartModule.this.getTopLevelAncestor().validate();
                    ChartModule.this.getTopLevelAncestor().repaint();
                    ChartModule.this.redraw();
                    ChartModule.this.scrollPane.setViewportView(ChartModule.this.chart);
                }
            });
        }
        ProgressDialogManager.closeProgressDialog(progress);
    }

    public boolean isGraphing(String name) {
        Vector levels = this.chart.getLevels();
        Iterator levelsIterator = levels.iterator();
        name = name.toUpperCase();
        while (levelsIterator.hasNext()) {
            Vector graphs = (Vector)levelsIterator.next();
            Iterator graphIterator = graphs.iterator();
            while (graphIterator.hasNext()) {
                Graph graph = (Graph)graphIterator.next();
                if (!name.equals(graph.getSourceName())) continue;
                return true;
            }
        }
        return false;
    }

    public void add(Graph graph, Portfolio portfolio, QuoteBundle quoteBundle, int level) {
        this.chart.add(graph, level);
        PortfolioChartMenu menu = new PortfolioChartMenu(this, quoteBundle, portfolio, graph);
        this.addMenu(menu);
    }

    public void addMarketIndicator(Graph graph) {
        this.chart.add(graph, 0);
        this.addMenu(new MarketIndicatorChartMenu(this, graph));
    }

    public void append(Graph graph, int level) {
        this.chart.add(graph, level);
    }

    public void append(Graph graph) {
        this.append(graph, this.chart.getLevels().size());
    }

    public void remove(Graph graph) {
        this.chart.remove(graph);
    }

    public int count() {
        return this.chart.count();
    }

    public void removeAll(String name) {
        Vector<Graph> graphsToRemove = new Vector<Graph>();
        Vector levels = this.chart.getLevels();
        Iterator levelsIterator = levels.iterator();
        while (levelsIterator.hasNext()) {
            Vector graphs = (Vector)levelsIterator.next();
            Iterator graphIterator = graphs.iterator();
            while (graphIterator.hasNext()) {
                Graph graph = (Graph)graphIterator.next();
                if (!name.equals(graph.getSourceName())) continue;
                graphsToRemove.add(graph);
            }
        }
        Iterator graphToRemoveIterator = graphsToRemove.iterator();
        while (graphToRemoveIterator.hasNext()) {
            this.chart.remove((Graph)graphToRemoveIterator.next());
        }
        int menus = this.menuBar.getMenuCount();
        for (int i = 1; i < menus; ++i) {
            JMenu currentMenu = this.menuBar.getMenu(i);
            if (!name.equals(currentMenu.getText())) continue;
            this.menuBar.remove(currentMenu);
            break;
        }
        this.propertySupport.firePropertyChange("titlebar changed", 0, 1);
        if (this.count() == 0) {
            this.propertySupport.firePropertyChange("window close", 0, 1);
        }
    }

    public void handleAnnotation(Graph graph, boolean enabled) {
        this.chart.handleAnnotation(graph, enabled);
    }

    public String getTitle() {
        return this.chart.getTitle();
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public void mouseClicked(MouseEvent e) {
        this.chart.clearHighlightedRegion();
        if (this.zoomIn != null) {
            this.zoomInEnabled = false;
            this.zoomIn.setEnabled(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Comparable x = this.chart.getXAtPoint(e.getX());
        Integer y = new Integer(e.getY());
        if (x != null && !this.inDrawMode && !this.inEraseMode) {
            this.chart.setHighlightedStart(x);
        }
        if (x != null && this.inDrawMode) {
            this.chart.setDrawnLineStart(new Integer(e.getX()), y);
            this.newLine = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        Comparable x = this.chart.getXAtPoint(e.getX());
        Integer y = new Integer(e.getY());
        if (x != null && this.inDrawMode) {
            this.chart.setDrawnLineEnd(new Integer(e.getX()), y, this.newLine);
            if (this.newLine) {
                this.newLine = false;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        Comparable x = this.chart.getXAtPoint(e.getX());
        Integer y = new Integer(e.getY());
        if (this.zoomIn != null && !this.inDrawMode && !this.inEraseMode) {
            this.zoomInEnabled = true;
            this.zoomIn.setEnabled(true);
        }
        if (x != null && !this.inDrawMode) {
            this.chart.setHighlightedEnd(x);
        }
        if (x != null && this.inDrawMode) {
            this.chart.setDrawnLineEnd(new Integer(e.getX()), y, this.newLine);
            if (this.newLine) {
                this.newLine = false;
            }
        }
        if (x != null && this.inEraseMode) {
            this.chart.setErase(new Integer(e.getX()), y);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.zoomIn != null && e.getSource() == this.zoomIn) {
            this.chart.zoomToHighlightedRegion();
            this.zoomInEnabled = false;
            this.zoomIn.setEnabled(false);
            this.defaultZoomEnabled = true;
            this.defaultZoom.setEnabled(true);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.repaint();
        } else if (this.defaultZoom != null && e.getSource() == this.defaultZoom) {
            this.chart.zoomToDefaultRegion();
            this.defaultZoomEnabled = false;
            this.defaultZoom.setEnabled(false);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.repaint();
        } else if (this.paintOnChart != null && e.getSource() == this.paintOnChart) {
            if (!this.inDrawMode) {
                this.previousDefaultZoomState = this.defaultZoomEnabled;
                this.defaultZoomEnabled = false;
                this.defaultZoom.setEnabled(false);
                this.inDrawMode = true;
                this.inEraseMode = false;
            } else {
                this.defaultZoomEnabled = this.previousDefaultZoomState;
                this.defaultZoom.setEnabled(this.defaultZoomEnabled);
                this.inDrawMode = false;
            }
        } else if (this.eraseOnChart != null && e.getSource() == this.eraseOnChart) {
            if (!this.inEraseMode) {
                this.previousDefaultZoomState = this.defaultZoomEnabled;
                this.defaultZoomEnabled = false;
                this.defaultZoom.setEnabled(false);
                this.inEraseMode = true;
                this.inDrawMode = false;
            } else {
                this.defaultZoomEnabled = this.previousDefaultZoomState;
                this.defaultZoom.setEnabled(this.defaultZoomEnabled);
                this.inEraseMode = false;
            }
        } else if (e.getSource() == this.closeMenuItem) {
            this.propertySupport.firePropertyChange("window close", 0, 1);
        } else if (e.getSource() == this.addMenuItem) {
            Thread menuAction = new Thread(){

                public void run() {
                    SortedSet symbols = SymbolListDialog.getSymbols(ChartModule.this.desktop, Locale.getString("ADD_GRAPH"));
                    if (symbols != null) {
                        TreeSet<Symbol> newSymbols = new TreeSet<Symbol>();
                        Iterator iterator = symbols.iterator();
                        while (iterator.hasNext()) {
                            Symbol symbol = (Symbol)iterator.next();
                            if (ChartModule.this.isGraphing(symbol.toString())) continue;
                            newSymbols.add(symbol);
                        }
                        if (newSymbols.size() > 0) {
                            ChartModule.this.add(newSymbols);
                        }
                    }
                }
            };
            menuAction.start();
        }
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public ImageIcon getFrameIcon() {
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.frameIcon));
    }

    public boolean encloseInScrollPane() {
        return false;
    }

    public void save() {
    }

    public BufferedImage getImage() {
        return this.chart.getImage();
    }

    static {
        $assertionsDisabled = !ChartModule.class.desiredAssertionStatus();
        TOOLBAR_GRAPHIC_SIZE = 12;
    }
}

