/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;

public class GraphSettingsDialog
extends JInternalFrame {
    private static final int DIALOG_IS_UP = 0;
    public static final int ADD = 1;
    public static final int CANCEL = 4;
    private int buttonPressed = 0;
    private GraphUI graphUI;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphSettingsDialog(GraphUI graphUI, String name) {
        super(name);
        this.graphUI = graphUI;
        this.buildUI(graphUI);
    }

    public int showDialog() {
        Dimension size = this.getPreferredSize();
        int x = (DesktopManager.getDesktop().getWidth() - size.width) / 2;
        int y = (DesktopManager.getDesktop().getHeight() - size.height) / 2;
        this.setBounds(x, y, size.width, size.height);
        DesktopManager.getDesktop().add(this);
        this.show();
        try {
            while (this.buttonPressed == 0) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.buttonPressed;
    }

    public HashMap getSettings() {
        if (!$assertionsDisabled && this.buttonPressed != 1) {
            throw new AssertionError();
        }
        return this.graphUI.getSettings();
    }

    private void buildUI(GraphUI graphUI) {
        JButton addButton = new JButton(Locale.getString("ADD"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphSettingsDialog.this.checkSettings()) {
                    GraphSettingsDialog.this.buttonPressed = 1;
                    GraphSettingsDialog.this.dispose();
                }
            }
        });
        JButton cancelButton = new JButton(Locale.getString("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphSettingsDialog.this.buttonPressed = 4;
                GraphSettingsDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel();
        TitledBorder border = new TitledBorder(Locale.getString("SETTINGS"));
        BorderLayout layout = new BorderLayout();
        panel.setBorder(border);
        panel.setLayout(layout);
        panel.add(graphUI.getPanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addButton);
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private boolean checkSettings() {
        String error = this.graphUI.checkSettings();
        if (error != null) {
            JOptionPane.showInternalMessageDialog(this, error, Locale.getString("ERROR_GRAPH_SETTINGS_TITLE"), 0);
        }
        return error == null;
    }

    static {
        $assertionsDisabled = !GraphSettingsDialog.class.desiredAssertionStatus();
    }
}

