/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.mov.chart.Graphable;
import org.mov.chart.PFGraphable;

public class GraphTools {
    public static void renderHorizontalLine(Graphics g, double yValue, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        int startX = xoffset;
        int endX = (int)((double)xoffset + (double)(xRange.size() - 1) * horizontalScale);
        int y = yoffset - GraphTools.scaleAndFitPoint(yValue, bottomLineValue, verticalScale);
        g.drawLine(startX, y, endX, y);
    }

    public static void renderLine(Graphics g, Graphable source, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        int lastXCoordinate = -1;
        int lastYCoordinate = -1;
        Iterator iterator = xRange.iterator();
        int i = 0;
        int halfbarWidth = (int)(0.309 * horizontalScale);
        int halfBlankWidth = (int)(horizontalScale - (double)(halfbarWidth * 2)) / 2;
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (x.compareTo(source.getStartX()) < 0) {
                ++i;
                continue;
            }
            if (x.compareTo(source.getEndX()) > 0) break;
            Double y = source.getY(x);
            if (y != null) {
                int xCoordinate = (int)((double)xoffset + horizontalScale * (double)i);
                int yCoordinate = yoffset - GraphTools.scaleAndFitPoint(y, bottomLineValue, verticalScale);
                if (lastXCoordinate != -1) {
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, yCoordinate, lastXCoordinate, lastYCoordinate);
                } else {
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, yCoordinate, xCoordinate + halfbarWidth + 1 + halfBlankWidth, yCoordinate);
                }
                lastXCoordinate = xCoordinate + halfbarWidth + 1 + halfBlankWidth;
                lastYCoordinate = yCoordinate;
            }
            ++i;
        }
    }

    public static void renderBar(Graphics g, Graphable source, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        int halfbarWidth = (int)(0.309 * horizontalScale);
        int halfBlankWidth = (int)(horizontalScale - (double)(halfbarWidth * 2)) / 2;
        Iterator iterator = xRange.iterator();
        int i = 0;
        int y2 = yoffset - GraphTools.scaleAndFitPoint(0.0, bottomLineValue, verticalScale);
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (x.compareTo(source.getStartX()) < 0) {
                ++i;
                continue;
            }
            if (x.compareTo(source.getEndX()) > 0) break;
            Double y = source.getY(x);
            double doubleValue = y == null ? 0.0 : y;
            int x2 = (int)((double)xoffset + horizontalScale * (double)i);
            int y1 = yoffset - GraphTools.scaleAndFitPoint(doubleValue, bottomLineValue, verticalScale);
            g.fillRect(x2 + halfBlankWidth, Math.min(y1, y2), halfbarWidth * 2 + 1, Math.abs(y2 - y1));
            ++i;
        }
    }

    public static int scaleAndFitPoint(double point, double offset, double scale) {
        return (int)((point - offset) * scale);
    }

    public static void renderChar(Graphics g, PFGraphable source, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        int lastXCoordinate = -1;
        int lastYCoordinate = -1;
        Iterator iterator = xRange.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (x.compareTo(source.getStartX()) < 0) {
                ++i;
                continue;
            }
            if (x.compareTo(source.getEndX()) > 0) break;
            Vector yList = source.getYList(x);
            for (int j = 0; yList != null && j < yList.size(); ++j) {
                Double y = (Double)yList.elementAt(j);
                if (y == null) continue;
                int xCoordinate = (int)((double)xoffset + horizontalScale * (double)i);
                int yCoordinate = yoffset - GraphTools.scaleAndFitPoint(y, bottomLineValue, verticalScale);
                g.drawString(source.getString(x), xCoordinate, yCoordinate);
            }
            ++i;
        }
    }
}

