/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import org.mov.chart.Graphable;
import org.mov.parser.EvaluationException;
import org.mov.quote.QuoteFunctionSource;
import org.mov.util.TradingDate;

public class GraphableQuoteFunctionSource
implements QuoteFunctionSource {
    private Graphable graphable;
    private TradingDate date;
    private int period;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphableQuoteFunctionSource(Graphable graphable, TradingDate date, int period) {
        this.graphable = graphable;
        this.date = date;
        this.period = period;
    }

    public void setDate(TradingDate date) {
        this.date = date;
    }

    public double getValue(int index) throws EvaluationException {
        if (!($assertionsDisabled || index >= 0 && index < this.period)) {
            throw new AssertionError();
        }
        TradingDate currentDate = this.date.previous(this.period - index - 1);
        Double value = this.graphable.getY(currentDate);
        if (value != null) {
            return value;
        }
        return Double.NaN;
    }

    static {
        $assertionsDisabled = !GraphableQuoteFunctionSource.class.desiredAssertionStatus();
    }
}

