/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Graphics;
import java.util.Iterator;
import java.util.Vector;
import org.mov.util.TradingDate;

public class HorizontalAxis {
    public static final int YEARS = 0;
    public static final int QUARTERS = 1;
    public static final int MONTHS = 2;
    private static final int MONTHS_PER_QUARTER = 3;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    static final int STATIC_GRID_HEIGHT = 5;
    static final int VARIABLE_GRID_HEIGHT_SCALE = 50;
    static final double MAJOR_MINOR_GRID_PROPORTION = 1.5;
    private Vector dates;
    private Vector points;
    private int period;
    private int type;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HorizontalAxis(Vector dates, int period, int type) {
        Iterator iterator = dates.iterator();
        TradingDate thisDate = null;
        int lastValue = -1;
        int i = 0;
        if (!$assertionsDisabled && dates.size() <= 0) {
            throw new AssertionError();
        }
        this.period = period;
        this.type = type;
        this.dates = new Vector();
        this.points = new Vector();
        while (iterator.hasNext()) {
            thisDate = (TradingDate)iterator.next();
            int thisValue = this.value(thisDate);
            if (lastValue == -1 || !iterator.hasNext() || thisValue != lastValue) {
                this.add(thisDate, new Integer(i));
            }
            ++i;
            lastValue = thisValue;
        }
    }

    public void drawLabels(Graphics g, double scale, int x, int y) {
        int lastValue = 0;
        Iterator dateIterator = this.dates.iterator();
        Iterator pointIterator = this.points.iterator();
        if (!$assertionsDisabled && this.dates.size() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.points.size() <= 0) {
            throw new AssertionError();
        }
        lastValue = (Integer)pointIterator.next();
        TradingDate lastDate = (TradingDate)dateIterator.next();
        while (pointIterator.hasNext()) {
            Integer value = (Integer)pointIterator.next();
            TradingDate date = (TradingDate)dateIterator.next();
            String string = this.stringValue(lastDate);
            int availableWidth = (int)((double)(value - lastValue) * scale);
            if ((double)availableWidth > 1.5 * (double)g.getFontMetrics().stringWidth(string)) {
                int midX = (int)((double)((value + lastValue) / 2) * scale) + x;
                int startX = midX - g.getFontMetrics().stringWidth(string) / 2;
                g.drawString(string, startX, y);
            }
            lastValue = value;
            lastDate = date;
        }
    }

    public static double calculateScale(int width, int dataPoints) {
        double horizontalScale = 1.0;
        if (dataPoints < width) {
            horizontalScale = (double)width / (double)dataPoints;
        }
        return horizontalScale;
    }

    public void drawGrid(Graphics g, int y, double horizontalScale, int heightOfGraph) {
        Iterator iterator = this.points.iterator();
        int i = 0;
        int lineSize = 5 + heightOfGraph / 50;
        if (this.getType() == 0) {
            lineSize = (int)((double)lineSize * 1.5);
        }
        while (iterator.hasNext()) {
            Integer axisPoint = (Integer)iterator.next();
            if (i++ <= 0 || !iterator.hasNext()) continue;
            g.drawLine((int)((double)axisPoint.intValue() * horizontalScale), y, (int)((double)axisPoint.intValue() * horizontalScale), y - lineSize);
        }
    }

    private void add(TradingDate date, Integer point) {
        this.dates.add(date);
        this.points.add(point);
    }

    private int getPeriod() {
        return this.period;
    }

    private int getType() {
        return this.type;
    }

    private String stringValue(TradingDate date) {
        switch (this.period) {
            case 0: {
                return Integer.toString(this.value(date));
            }
            case 1: {
                return "Q" + Integer.toString(this.value(date));
            }
            case 2: {
                return TradingDate.monthToText(this.value(date));
            }
        }
        return "???";
    }

    private int value(TradingDate date) {
        switch (this.period) {
            case 0: {
                return date.getYear();
            }
            case 1: {
                return (date.getMonth() - 1) / 3 + 1;
            }
            case 2: {
                return date.getMonth();
            }
        }
        return 0;
    }

    public int getWidth() {
        if (this.points.size() > 2) {
            return (Integer)this.points.elementAt(2) - (Integer)this.points.elementAt(1);
        }
        if (this.points.size() > 1) {
            return (Integer)this.points.elementAt(1) - (Integer)this.points.elementAt(0);
        }
        return 0;
    }

    static {
        $assertionsDisabled = !HorizontalAxis.class.desiredAssertionStatus();
    }
}

