/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.mov.chart.ChartModule;
import org.mov.chart.graph.BarGraph;
import org.mov.chart.graph.Graph;
import org.mov.chart.graph.LineGraph;
import org.mov.chart.source.PortfolioGraphSource;
import org.mov.portfolio.Account;
import org.mov.portfolio.Portfolio;
import org.mov.quote.QuoteBundle;
import org.mov.util.Locale;

public class PortfolioChartMenu
extends JMenu
implements ActionListener {
    private static final String CASH_VALUE = Locale.getString("CASH_VALUE");
    private static final String SHARE_VALUE = Locale.getString("SHARE_VALUE");
    private static final String RETURN_VALUE = Locale.getString("RETURN_VALUE");
    private static final String STOCKS_HELD = Locale.getString("STOCKS_HELD");
    JMenu graphMenu;
    JMenu annotateMenu;
    private JMenuItem removeMenu;
    private QuoteBundle quoteBundle;
    private Graph graph;
    private ChartModule listener;
    private HashMap map = new HashMap();
    private Portfolio portfolio;

    public PortfolioChartMenu(ChartModule listener, QuoteBundle quoteBundle, Portfolio portfolio, Graph graph) {
        super(graph.getSourceName());
        this.quoteBundle = quoteBundle;
        this.graph = graph;
        this.listener = listener;
        this.portfolio = portfolio;
        this.graphMenu = new JMenu(Locale.getString("GRAPH"));
        this.add(this.graphMenu);
        this.addMenuItem(CASH_VALUE);
        this.addMenuItem(SHARE_VALUE);
        this.addMenuItem(RETURN_VALUE);
        this.addMenuItem(STOCKS_HELD);
        this.graphMenu.addSeparator();
        List accounts = portfolio.getAccounts();
        Iterator iterator = accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            this.addMenuItem(account.getName());
        }
        this.addSeparator();
        this.removeMenu = new JMenuItem(Locale.getString("REMOVE"));
        this.removeMenu.addActionListener(this);
        this.add(this.removeMenu);
    }

    private void addMenuItem(String label) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
        item.addActionListener(this);
        this.graphMenu.add(item);
    }

    public String getName() {
        return this.graph.getSourceName();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeMenu) {
            this.listener.removeAll(this.getName());
            this.listener.redraw();
        } else {
            JCheckBoxMenuItem menu = (JCheckBoxMenuItem)e.getSource();
            String text = menu.getText();
            if (!menu.getState()) {
                this.removeGraph(text);
            } else if (text == RETURN_VALUE) {
                this.addGraph(new LineGraph(new PortfolioGraphSource(this.portfolio, this.quoteBundle, 1), RETURN_VALUE, true), RETURN_VALUE, 0);
            } else if (text == CASH_VALUE) {
                this.addGraph(new LineGraph(new PortfolioGraphSource(this.portfolio, this.quoteBundle, 2), CASH_VALUE, true), CASH_VALUE, 0);
            } else if (text == SHARE_VALUE) {
                this.addGraph(new LineGraph(new PortfolioGraphSource(this.portfolio, this.quoteBundle, 3), SHARE_VALUE, true), SHARE_VALUE, 0);
            } else if (text == STOCKS_HELD) {
                this.addGraph(new BarGraph(new PortfolioGraphSource(this.portfolio, this.quoteBundle, 4), STOCKS_HELD, false), STOCKS_HELD);
            } else {
                String accountName = text;
                this.addGraph(new LineGraph(new PortfolioGraphSource(this.portfolio, this.quoteBundle, accountName), accountName, true), accountName, 0);
            }
        }
    }

    private void addGraph(Graph graph, String mapIdentifier) {
        this.map.put(mapIdentifier, graph);
        this.listener.append(graph);
        this.listener.redraw();
    }

    private void addGraph(Graph graph, String mapIdentifier, int index) {
        this.map.put(mapIdentifier, graph);
        this.listener.append(graph, index);
        this.listener.redraw();
    }

    private void removeGraph(String mapIdentifier) {
        Graph graph = (Graph)this.map.get(mapIdentifier);
        this.map.remove(mapIdentifier);
        this.listener.remove(graph);
        this.listener.handleAnnotation(graph, false);
        this.listener.redraw();
    }
}

