/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.mov.chart.ChartModule;
import org.mov.chart.GraphSettingsDialog;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.BarChartGraph;
import org.mov.chart.graph.BarGraph;
import org.mov.chart.graph.BollingerBandsGraph;
import org.mov.chart.graph.CandleStickGraph;
import org.mov.chart.graph.CustomGraph;
import org.mov.chart.graph.ExpMovingAverageGraph;
import org.mov.chart.graph.Graph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.HighLowBarGraph;
import org.mov.chart.graph.LineGraph;
import org.mov.chart.graph.MACDGraph;
import org.mov.chart.graph.MomentumGraph;
import org.mov.chart.graph.MovingAverageGraph;
import org.mov.chart.graph.OBVGraph;
import org.mov.chart.graph.PointAndFigureGraph;
import org.mov.chart.graph.RSIGraph;
import org.mov.chart.graph.StandardDeviationGraph;
import org.mov.chart.graph.SupportAndResistenceGraph;
import org.mov.chart.source.GraphSource;
import org.mov.chart.source.OHLCVIndexQuoteGraphSource;
import org.mov.chart.source.OHLCVQuoteGraphSource;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Locale;

public class QuoteChartMenu
extends JMenu {
    private QuoteBundle quoteBundle;
    private ChartModule listener;
    private HashMap map = new HashMap();
    private Graph currentViewGraph = null;
    private JRadioButtonMenuItem currentViewMenuItem = null;
    private String menuName = null;
    private Symbol symbol = null;
    private GraphSource dayOpenGraphSource = null;
    private GraphSource dayHighGraphSource = null;
    private GraphSource dayLowGraphSource = null;
    private GraphSource dayCloseGraphSource = null;
    private GraphSource dayVolumeGraphSource = null;
    private boolean indexChart = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteChartMenu(ChartModule listener, QuoteBundle quoteBundle, Symbol symbol, Graph graph, boolean indexChart) {
        super(graph.getSourceName());
        this.menuName = graph.getSourceName();
        this.quoteBundle = quoteBundle;
        this.symbol = symbol;
        this.listener = listener;
        this.currentViewGraph = graph;
        this.indexChart = indexChart;
        this.buildMenu();
    }

    private void buildMenu() {
        JMenu graphMenu = new JMenu(Locale.getString("GRAPH"));
        ButtonGroup group = new ButtonGroup();
        this.currentViewMenuItem = this.addViewMenuItem(graphMenu, group, Locale.getString("LINE_CHART"), true);
        this.addViewMenuItem(graphMenu, group, Locale.getString("BAR_CHART"), false);
        this.addViewMenuItem(graphMenu, group, Locale.getString("CANDLE_STICK"), false);
        this.addViewMenuItem(graphMenu, group, Locale.getString("HIGH_LOW_BAR"), false);
        this.addViewMenuItem(graphMenu, group, Locale.getString("POINT_AND_FIGURE"), false);
        graphMenu.addSeparator();
        this.addMenuItem(graphMenu, Locale.getString("BOLLINGER_BANDS"));
        this.addMenuItem(graphMenu, Locale.getString("CUSTOM"));
        this.addMenuItem(graphMenu, Locale.getString("DAY_OPEN"));
        this.addMenuItem(graphMenu, Locale.getString("DAY_HIGH"));
        this.addMenuItem(graphMenu, Locale.getString("DAY_LOW"));
        this.addMenuItem(graphMenu, Locale.getString("VOLUME"));
        this.addMenuItem(graphMenu, Locale.getString("MOMENTUM"));
        this.addMenuItem(graphMenu, Locale.getString("MACD"));
        this.addMenuItem(graphMenu, Locale.getString("SIMPLE_MOVING_AVERAGE"));
        this.addMenuItem(graphMenu, Locale.getString("EXP_MOVING_AVERAGE"));
        this.addMenuItem(graphMenu, Locale.getString("OBV"));
        this.addMenuItem(graphMenu, Locale.getString("RSI"));
        this.addMenuItem(graphMenu, Locale.getString("STANDARD_DEVIATION"));
        JMenuItem removeMenu = new JMenuItem(Locale.getString("REMOVE"));
        removeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuoteChartMenu.this.listener.removeAll(QuoteChartMenu.this.getName());
                if (QuoteChartMenu.this.listener.count() > 0) {
                    QuoteChartMenu.this.listener.redraw();
                }
            }
        });
        this.add(graphMenu);
        this.add(removeMenu);
    }

    private JRadioButtonMenuItem addViewMenuItem(JMenu menu, ButtonGroup group, String label, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
        group.add(item);
        item.setSelected(isSelected);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)e.getSource();
                String text = menuItem.getText();
                Thread thread2 = new Thread(this, text, menuItem){
                    private final /* synthetic */ String val$text;
                    private final /* synthetic */ JRadioButtonMenuItem val$menuItem;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$text = val$text;
                        this.val$menuItem = val$menuItem;
                    }

                    public void run() {
                        Graph graph = QuoteChartMenu.access$200(2.access$100(this.this$1), this.val$text);
                        if (graph != null) {
                            if (QuoteChartMenu.access$300(2.access$100(this.this$1)) != null) {
                                QuoteChartMenu.access$000(2.access$100(this.this$1)).remove(QuoteChartMenu.access$300(2.access$100(this.this$1)));
                            }
                            QuoteChartMenu.access$400(2.access$100(this.this$1), graph);
                            QuoteChartMenu.access$302(2.access$100(this.this$1), graph);
                            QuoteChartMenu.access$502(2.access$100(this.this$1), this.val$menuItem);
                        } else if (QuoteChartMenu.access$500(2.access$100(this.this$1)) != null) {
                            QuoteChartMenu.access$500(2.access$100(this.this$1)).setSelected(true);
                        }
                    }
                };
                thread2.start();
            }

            static /* synthetic */ QuoteChartMenu access$100(2 x0) {
                return x0.QuoteChartMenu.this;
            }
        });
        menu.add(item);
        return item;
    }

    private void addMenuItem(JMenu menu, String label) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                String text = menuItem.getText();
                if (!menuItem.getState()) {
                    QuoteChartMenu.this.removeGraph(text);
                } else {
                    Thread thread2 = new Thread(this, text, menuItem){
                        private final /* synthetic */ String val$text;
                        private final /* synthetic */ JCheckBoxMenuItem val$menuItem;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$text = val$text;
                            this.val$menuItem = val$menuItem;
                        }

                        public void run() {
                            Graph graph = QuoteChartMenu.access$200(4.access$700(this.this$1), this.val$text);
                            if (graph != null) {
                                QuoteChartMenu.access$400(4.access$700(this.this$1), graph);
                            } else {
                                this.val$menuItem.setSelected(false);
                            }
                        }
                    };
                    thread2.start();
                }
            }

            static /* synthetic */ QuoteChartMenu access$700(4 x0) {
                return x0.QuoteChartMenu.this;
            }
        });
        menu.add(item);
    }

    public String getName() {
        return this.menuName;
    }

    private GraphSource getDayOpen() {
        if (this.dayOpenGraphSource == null) {
            this.dayOpenGraphSource = this.indexChart ? new OHLCVIndexQuoteGraphSource(this.quoteBundle, 1) : new OHLCVQuoteGraphSource(this.quoteBundle, 1);
        }
        return this.dayOpenGraphSource;
    }

    private GraphSource getDayHigh() {
        if (this.dayHighGraphSource == null) {
            this.dayHighGraphSource = this.indexChart ? new OHLCVIndexQuoteGraphSource(this.quoteBundle, 3) : new OHLCVQuoteGraphSource(this.quoteBundle, 3);
        }
        return this.dayHighGraphSource;
    }

    private GraphSource getDayLow() {
        if (this.dayLowGraphSource == null) {
            this.dayLowGraphSource = this.indexChart ? new OHLCVIndexQuoteGraphSource(this.quoteBundle, 2) : new OHLCVQuoteGraphSource(this.quoteBundle, 2);
        }
        return this.dayLowGraphSource;
    }

    private GraphSource getDayClose() {
        if (this.dayCloseGraphSource == null) {
            this.dayCloseGraphSource = this.indexChart ? new OHLCVIndexQuoteGraphSource(this.quoteBundle, 0) : new OHLCVQuoteGraphSource(this.quoteBundle, 0);
        }
        return this.dayCloseGraphSource;
    }

    private GraphSource getDayVolume() {
        this.dayVolumeGraphSource = this.dayVolumeGraphSource == null ? new OHLCVIndexQuoteGraphSource(this.quoteBundle, 4) : new OHLCVQuoteGraphSource(this.quoteBundle, 4);
        return this.dayVolumeGraphSource;
    }

    private Graph getGraph(String text) {
        Graph graph = this.newGraph(text);
        GraphUI graphUI = graph.getUI(new HashMap());
        if (graphUI != null) {
            GraphSettingsDialog dialog = new GraphSettingsDialog(graphUI, graph.getName());
            int buttonPressed = dialog.showDialog();
            if (buttonPressed == 1) {
                graph.setSettings(dialog.getSettings());
            } else {
                graph = null;
            }
        }
        return graph;
    }

    private void addGraph(Graph graph) {
        String mapIdentifier = graph.getName();
        this.map.put(mapIdentifier, graph);
        if (graph.isPrimary()) {
            this.listener.append(graph, 0);
        } else {
            this.listener.append(graph);
        }
        this.listener.redraw();
    }

    private void removeGraph(String mapIdentifier) {
        Graph graph = (Graph)this.map.get(mapIdentifier);
        this.map.remove(mapIdentifier);
        this.listener.remove(graph);
        this.listener.redraw();
    }

    private Graph newGraph(String text) {
        AbstractGraph graph;
        if (text == Locale.getString("BAR_CHART")) {
            graph = new BarChartGraph(this.getDayOpen(), this.getDayLow(), this.getDayHigh(), this.getDayClose());
        } else if (text == Locale.getString("BOLLINGER_BANDS")) {
            graph = new BollingerBandsGraph(this.getDayClose());
        } else if (text == Locale.getString("CANDLE_STICK")) {
            graph = new CandleStickGraph(this.getDayOpen(), this.getDayLow(), this.getDayHigh(), this.getDayClose());
        } else if (text == Locale.getString("CUSTOM")) {
            graph = new CustomGraph(this.getDayClose(), this.symbol, this.quoteBundle);
        } else if (text == Locale.getString("DAY_HIGH")) {
            graph = new LineGraph(this.getDayHigh(), text, true);
        } else if (text == Locale.getString("DAY_LOW")) {
            graph = new LineGraph(this.getDayLow(), text, true);
        } else if (text == Locale.getString("DAY_OPEN")) {
            graph = new LineGraph(this.getDayOpen(), text, true);
        } else if (text == Locale.getString("VOLUME")) {
            graph = new BarGraph(this.getDayVolume(), text, false);
        } else if (text == Locale.getString("EXP_MOVING_AVERAGE")) {
            graph = new ExpMovingAverageGraph(this.getDayClose());
        } else if (text == Locale.getString("HIGH_LOW_BAR")) {
            graph = new HighLowBarGraph(this.getDayLow(), this.getDayHigh(), this.getDayClose());
        } else if (text == Locale.getString("MACD")) {
            graph = new MACDGraph(this.getDayClose());
        } else if (text == Locale.getString("MOMENTUM")) {
            graph = new MomentumGraph(this.getDayClose());
        } else if (text == Locale.getString("OBV")) {
            graph = new OBVGraph(this.getDayOpen(), this.getDayClose(), this.getDayVolume());
        } else if (text == Locale.getString("POINT_AND_FIGURE")) {
            graph = new PointAndFigureGraph(this.getDayClose());
        } else if (text == Locale.getString("SUPPORT_AND_RESISTENCE")) {
            graph = new SupportAndResistenceGraph(this.getDayClose());
        } else if (text == Locale.getString("RSI")) {
            graph = new RSIGraph(this.getDayClose());
        } else if (text == Locale.getString("SIMPLE_MOVING_AVERAGE")) {
            graph = new MovingAverageGraph(this.getDayClose());
        } else if (text == Locale.getString("STANDARD_DEVIATION")) {
            graph = new StandardDeviationGraph(this.getDayClose());
        } else {
            if (!$assertionsDisabled && text != Locale.getString("LINE_CHART")) {
                throw new AssertionError();
            }
            graph = new LineGraph(this.getDayClose(), text, true);
        }
        if (!$assertionsDisabled && text != graph.getName()) {
            throw new AssertionError();
        }
        return graph;
    }

    static /* synthetic */ Graph access$200(QuoteChartMenu x0, String x1) {
        return x0.getGraph(x1);
    }

    static /* synthetic */ Graph access$300(QuoteChartMenu x0) {
        return x0.currentViewGraph;
    }

    static /* synthetic */ void access$400(QuoteChartMenu x0, Graph x1) {
        x0.addGraph(x1);
    }

    static /* synthetic */ Graph access$302(QuoteChartMenu x0, Graph x1) {
        x0.currentViewGraph = x1;
        return x0.currentViewGraph;
    }

    static /* synthetic */ JRadioButtonMenuItem access$502(QuoteChartMenu x0, JRadioButtonMenuItem x1) {
        x0.currentViewMenuItem = x1;
        return x0.currentViewMenuItem;
    }

    static /* synthetic */ JRadioButtonMenuItem access$500(QuoteChartMenu x0) {
        return x0.currentViewMenuItem;
    }

    static {
        $assertionsDisabled = !QuoteChartMenu.class.desiredAssertionStatus();
    }
}

