/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;

public class UserNotes
extends JInternalFrame {
    private JTextArea notes;
    private String symbol;

    public UserNotes(String name) {
        String prevText = "";
        this.symbol = name;
        String frameTitle = "Notes for " + name;
        this.setTitle(frameTitle);
        this.setSize(250, 250);
        this.setVisible(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        DesktopManager.getDesktop().add(this);
        JPanel notePane = new JPanel();
        JPanel buttonPane = new JPanel();
        this.notes = new JTextArea(10, 15);
        prevText = PreferencesManager.loadUserNotes(this.symbol);
        if (prevText != "") {
            this.notes.setText(prevText);
        }
        JScrollPane noteContainer = new JScrollPane(this.notes);
        JButton save = new JButton(Locale.getString("SAVE"));
        JButton close = new JButton(Locale.getString("CLOSE"));
        JButton revert = new JButton(Locale.getString("REVERT"));
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PreferencesManager.saveUserNotes(UserNotes.this.symbol, UserNotes.this.notes.getText());
                    UserNotes.this.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    UserNotes.this.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        revert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String foo = PreferencesManager.loadUserNotes(UserNotes.this.symbol);
                UserNotes.this.notes.setText(foo);
            }
        });
        notePane.add((Component)noteContainer, "Center");
        buttonPane.add((Component)save, "West");
        buttonPane.add((Component)close, "Center");
        buttonPane.add((Component)revert, "East");
        this.getContentPane().add((Component)notePane, "Center");
        this.getContentPane().add((Component)buttonPane, "South");
    }

    public void setText(String text) {
    }
}

