/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart;

import java.awt.Font;
import java.awt.Graphics;
import org.mov.chart.graph.Graph;

public class VerticalAxis {
    static final int MINIMUM_HORIZONTAL_LINES = 4;
    static final int MAX_HORIZONTAL_LINE_SPACING = 125;
    static final int Y_LABEL_VERTICAL_OFFSET = 5;
    static final int Y_LABEL_HORIZONTAL_OFFSET = 10;
    static final int Y_LABEL_WIDTH = 60;
    private double lowest;
    private double highest;
    private double[] minor;
    private double[] major;
    private int height = 0;
    private int horizontalLines;
    private int horizontalLineSpacing;
    private double valueDelta;
    private double bottomLineValue;
    private double topLineValue;
    private int heightOfGraph;
    private double scale;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VerticalAxis(double lowest, double highest, double[] minor, double[] major) {
        this.lowest = lowest;
        this.highest = highest;
        this.minor = minor;
        this.major = major;
    }

    public void setHeight(int height) {
        if (this.height != height) {
            this.height = height;
            this.calculateHorizontalLinesAndSpacing();
            this.calculateOptimumValueDelta();
            this.calculateHeightOfGraph();
            this.calculateScale();
        }
    }

    private void calculateHorizontalLinesAndSpacing() {
        this.horizontalLines = 4;
        do {
            this.horizontalLineSpacing = this.height / (++this.horizontalLines - 1);
        } while (this.horizontalLineSpacing > 125);
    }

    private void calculateOptimumValueDelta() {
        double exactWorth = Math.abs((this.highest - this.lowest) / (double)(this.horizontalLines - 1));
        for (int i = 0; i < this.major.length; ++i) {
            for (int j = 0; j < this.minor.length; ++j) {
                this.valueDelta = this.major[i] * this.minor[j];
                this.bottomLineValue = Math.floor(this.lowest / this.valueDelta) * this.valueDelta;
                this.topLineValue = this.bottomLineValue + (double)(this.horizontalLines - 1) * this.valueDelta;
                if (!(this.valueDelta > exactWorth) || !(this.topLineValue > this.highest)) continue;
                return;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this.valueDelta = 1.0E7;
    }

    private void calculateHeightOfGraph() {
        this.heightOfGraph = (this.horizontalLines - 1) * this.horizontalLineSpacing;
    }

    private void calculateScale() {
        this.scale = (double)this.heightOfGraph / (this.topLineValue - this.bottomLineValue);
    }

    public double getBottomLineValue() {
        return this.bottomLineValue;
    }

    public double getTopLineValue() {
        return this.topLineValue;
    }

    public int getHeightOfGraph() {
        return this.heightOfGraph;
    }

    public double getScale() {
        return this.scale;
    }

    public void drawGridAndLabels(Graphics g, Graph graph, String title, int xoffset, int yoffset, int width) {
        int yLabelVerticalOffset = 5;
        Font originalFont = g.getFont();
        boolean everySecondLine = false;
        boolean firstLineOnly = false;
        if (yLabelVerticalOffset + g.getFontMetrics().getHeight() > this.horizontalLineSpacing) {
            yLabelVerticalOffset = 1;
        }
        if (g.getFontMetrics().getHeight() > this.horizontalLineSpacing) {
            g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() - 2.0f));
            yLabelVerticalOffset = 0;
        }
        if (g.getFontMetrics().getHeight() > this.horizontalLineSpacing + 2) {
            everySecondLine = true;
        }
        if (g.getFontMetrics().getHeight() > 2 * this.horizontalLineSpacing) {
            everySecondLine = false;
            firstLineOnly = true;
        }
        for (int i = 0; i < this.horizontalLines; ++i) {
            int y = i * this.horizontalLineSpacing + yoffset;
            String yLabel = graph.getYLabel(this.topLineValue - this.valueDelta * (double)i);
            int yLabelWidth = g.getFontMetrics().stringWidth(yLabel);
            g.drawLine(xoffset, y, xoffset + width + 60, y);
            if (firstLineOnly && i != 0 || everySecondLine && i % 2 != 0) continue;
            g.drawString(yLabel, xoffset + width + 60 - yLabelWidth - 10, y - yLabelVerticalOffset);
            if (i != 0) continue;
            g.drawString(title, xoffset + 10, y - yLabelVerticalOffset);
        }
        g.setFont(originalFont);
    }

    static {
        $assertionsDisabled = !VerticalAxis.class.desiredAssertionStatus();
    }
}

