/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.Graph;
import org.mov.chart.graph.GraphUI;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteSourceManager;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class AdvanceDeclineGraph
implements Graph {
    private Graphable advanceDecline = AdvanceDeclineGraph.createAdvanceDecline();
    private static final int START_VALUE = 0;

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        GraphTools.renderLine(g, this.advanceDecline, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public Comparable getStartX() {
        return this.advanceDecline.getStartX();
    }

    public Comparable getEndX() {
        return this.advanceDecline.getEndX();
    }

    public Set getXRange() {
        return this.advanceDecline.getXRange();
    }

    public String getYLabel(double value) {
        return Integer.toString((int)value);
    }

    public Double getY(Comparable x) {
        return this.advanceDecline.getY(x);
    }

    public double getHighestY(List x) {
        return this.advanceDecline.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.advanceDecline.getLowestY(x);
    }

    public double[] getAcceptableMajorDeltas() {
        double[] major = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0};
        return major;
    }

    public double[] getAcceptableMinorDeltas() {
        double[] minor = new double[]{1.0, 1.1, 1.25, 1.3333, 1.5, 2.0, 2.25, 2.5, 3.0, 3.3333, 4.0, 5.0, 6.0, 6.5, 7.0, 7.5, 8.0, 9.0};
        return minor;
    }

    public HashMap getAnnotations() {
        return null;
    }

    public boolean hasAnnotations() {
        return false;
    }

    public static Graphable createAdvanceDecline() {
        Graphable advanceDecline = new Graphable();
        TradingDate firstDate = QuoteSourceManager.getSource().getFirstDate();
        TradingDate lastDate = QuoteSourceManager.getSource().getLastDate();
        List dates = TradingDate.dateRangeToList(firstDate, lastDate);
        Thread thread2 = Thread.currentThread();
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.setIndeterminate(false);
        progress.setMaximum(dates.size());
        progress.setProgress(0);
        progress.setMaster(true);
        progress.show(Locale.getString("CALCULATING_ADVANCE_DECLINE"));
        int cumulativeAdvanceDecline = 0;
        Iterator iterator = dates.iterator();
        while (iterator.hasNext()) {
            TradingDate date = (TradingDate)iterator.next();
            try {
                int todayAdvanceDecline = QuoteSourceManager.getSource().getAdvanceDecline(date);
                advanceDecline.putY(date, new Double(cumulativeAdvanceDecline += todayAdvanceDecline));
            }
            catch (MissingQuoteException e) {
                // empty catch block
            }
            if (thread2.isInterrupted()) break;
            progress.increment();
        }
        ProgressDialogManager.closeProgressDialog(progress);
        return advanceDecline;
    }

    public HashMap getSettings() {
        return new HashMap();
    }

    public void setSettings(HashMap settings) {
    }

    public GraphUI getUI(HashMap settings) {
        return null;
    }

    public String getName() {
        return Locale.getString("ADVANCE_DECLINE");
    }

    public String getSourceName() {
        return Locale.getString("ADVANCE_DECLINE");
    }

    public boolean isPrimary() {
        return true;
    }
}

