/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.GraphableQuoteFunctionSource;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.PeriodGraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.parser.EvaluationException;
import org.mov.quote.QuoteFunctions;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class BollingerBandsGraph
extends AbstractGraph {
    private Graphable upperBand;
    private Graphable lowerBand;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BollingerBandsGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(Color.green.darker());
        GraphTools.renderLine(g, this.upperBand, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
        GraphTools.renderLine(g, this.lowerBand, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return this.upperBand.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.lowerBand.getLowestY(x);
    }

    public String getName() {
        return Locale.getString("BOLLINGER_BANDS");
    }

    public boolean isPrimary() {
        return true;
    }

    public GraphUI getUI(HashMap settings) {
        return new PeriodGraphUI(settings);
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        Graphable source = this.getSource().getGraphable();
        int period = PeriodGraphUI.getPeriod(settings);
        this.upperBand = new Graphable();
        this.lowerBand = new Graphable();
        TradingDate date = (TradingDate)source.getStartX();
        GraphableQuoteFunctionSource quoteFunctionSource = new GraphableQuoteFunctionSource(source, date, period);
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            date = (TradingDate)iterator.next();
            quoteFunctionSource.setDate(date);
            try {
                double bollingerTop = QuoteFunctions.bollingerUpper(quoteFunctionSource, period);
                this.upperBand.putY(date, new Double(bollingerTop));
                double bollingerBottom = QuoteFunctions.bollingerLower(quoteFunctionSource, period);
                this.lowerBand.putY(date, new Double(bollingerBottom));
            }
            catch (EvaluationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }
    }

    static {
        $assertionsDisabled = !BollingerBandsGraph.class.desiredAssertionStatus();
    }
}

