/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.source.GraphSource;
import org.mov.util.Locale;

public class CandleStickGraph
extends AbstractGraph {
    private Graphable dayOpen;
    private Graphable dayLow;
    private Graphable dayHigh;
    private Graphable dayClose;

    public CandleStickGraph(GraphSource dayOpen, GraphSource dayLow, GraphSource dayHigh, GraphSource dayClose) {
        super(dayClose);
        this.dayOpen = dayOpen.getGraphable();
        this.dayLow = dayLow.getGraphable();
        this.dayHigh = dayHigh.getGraphable();
        this.dayClose = dayClose.getGraphable();
    }

    public void render(Graphics g, Color c, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        Iterator iterator = xRange.iterator();
        int i = 0;
        int halfbarWidth = (int)(0.309 * horizontalScale);
        int halfBlankWidth = (int)(horizontalScale - (double)(halfbarWidth * 2)) / 2;
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (x.compareTo(this.dayClose.getStartX()) < 0) {
                ++i;
                continue;
            }
            if (x.compareTo(this.dayClose.getEndX()) > 0) break;
            Double dayOpenY = this.dayOpen.getY(x);
            Double dayLowY = this.dayLow.getY(x);
            Double dayHighY = this.dayHigh.getY(x);
            Double dayCloseY = this.dayClose.getY(x);
            if (dayLowY != null && dayHighY != null && dayCloseY != null && this.dayOpen != null) {
                int xCoordinate = (int)((double)xoffset + horizontalScale * (double)i);
                int openY = yoffset - GraphTools.scaleAndFitPoint(dayOpenY, bottomLineValue, verticalScale);
                int lowY = yoffset - GraphTools.scaleAndFitPoint(dayLowY, bottomLineValue, verticalScale);
                int highY = yoffset - GraphTools.scaleAndFitPoint(dayHighY, bottomLineValue, verticalScale);
                int closeY = yoffset - GraphTools.scaleAndFitPoint(dayCloseY, bottomLineValue, verticalScale);
                if (closeY > openY) {
                    g.setColor(Color.RED);
                    g.drawRect(xCoordinate + halfBlankWidth, openY, halfbarWidth * 2 + 1, closeY - openY);
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, lowY, xCoordinate + halfbarWidth + 1 + halfBlankWidth, closeY);
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, openY, xCoordinate + halfbarWidth + 1 + halfBlankWidth, highY);
                } else if (closeY < openY) {
                    g.setColor(Color.GREEN);
                    g.drawRect(xCoordinate + halfBlankWidth, closeY, halfbarWidth * 2 + 1, openY - closeY);
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, lowY, xCoordinate + halfbarWidth + 1 + halfBlankWidth, openY);
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, closeY, xCoordinate + halfbarWidth + 1 + halfBlankWidth, highY);
                } else {
                    g.setColor(Color.RED);
                    g.drawLine(xCoordinate + halfbarWidth + 1 + halfBlankWidth, lowY, xCoordinate + halfbarWidth + 1 + halfBlankWidth, highY);
                    g.drawLine(xCoordinate + halfBlankWidth, openY, xCoordinate + halfbarWidth * 2 + 1 + halfBlankWidth, openY);
                }
            }
            ++i;
        }
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        Double dayLowY = this.dayLow.getY(x);
        Double dayHighY = this.dayHigh.getY(x);
        if (dayLowY != null && dayHighY != null) {
            int dayLowYCoordinate = yoffset - GraphTools.scaleAndFitPoint(dayLowY, bottomLineValue, verticalScale);
            int dayHighYCoordinate = yoffset - GraphTools.scaleAndFitPoint(dayHighY, bottomLineValue, verticalScale);
            if (y <= dayLowYCoordinate + 50 && y >= dayHighYCoordinate - 50) {
                return this.getSource().getToolTipText(x);
            }
        }
        return null;
    }

    public double getHighestY(List x) {
        return this.dayHigh.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.dayLow.getLowestY(x);
    }

    public String getName() {
        return Locale.getString("CANDLE_STICK");
    }

    public boolean isPrimary() {
        return true;
    }
}

