/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.CustomGraphUI;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.quote.QuoteBundle;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Locale;

public class CustomGraph
extends AbstractGraph {
    private Graphable indicatorGraphable = null;
    private QuoteBundle quoteBundle;
    private Symbol symbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CustomGraph(GraphSource source, Symbol symbol, QuoteBundle quoteBundle) {
        super(source);
        this.symbol = symbol;
        this.quoteBundle = new ScriptQuoteBundle(quoteBundle);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(Color.green.darker());
        GraphTools.renderLine(g, this.indicatorGraphable, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public double getHighestY(List x) {
        return this.indicatorGraphable.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.indicatorGraphable.getLowestY(x);
    }

    public static Graphable createCustom(Expression indicator, Graphable source, QuoteBundle quoteBundle, Symbol symbol) {
        try {
            return CustomGraphUI.createCustom(indicator, source, quoteBundle, symbol);
        }
        catch (ExpressionException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public void setSettings(HashMap settings) {
        block3: {
            super.setSettings(settings);
            try {
                String indicatorText = CustomGraphUI.getIndicatorText(settings);
                if (indicatorText.length() > 0) {
                    Expression indicator = Parser.parse(indicatorText);
                    this.indicatorGraphable = CustomGraph.createCustom(indicator, this.getSource().getGraphable(), this.quoteBundle, this.symbol);
                }
            }
            catch (ExpressionException p) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public GraphUI getUI(HashMap settings) {
        return new CustomGraphUI(this.getSettings(), this.getSource().getGraphable(), this.quoteBundle, this.symbol);
    }

    public String getName() {
        return Locale.getString("CUSTOM");
    }

    public boolean isPrimary() {
        return CustomGraphUI.isPrimary(this.getSettings());
    }

    static {
        $assertionsDisabled = !CustomGraph.class.desiredAssertionStatus();
    }
}

