/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.mov.chart.Graphable;
import org.mov.chart.graph.GraphUI;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Variables;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.ui.EquationComboBox;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class CustomGraphUI
implements GraphUI {
    private Graphable source;
    private QuoteBundle quoteBundle;
    private Symbol symbol;
    private JPanel panel;
    private EquationComboBox indicatorComboBox;
    private JCheckBox isPrimaryCheckBox;
    private static final String INDICATOR = "indicator";
    private static final String IS_PRIMARY = "is_primary";

    public CustomGraphUI(HashMap settings, Graphable source, QuoteBundle quoteBundle, Symbol symbol) {
        this.source = source;
        this.quoteBundle = quoteBundle;
        this.symbol = symbol;
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.indicatorComboBox = GridBagHelper.addEquationRow(this.panel, Locale.getString("CUSTOM"), "", layout, c);
        this.isPrimaryCheckBox = GridBagHelper.addCheckBoxRow(this.panel, Locale.getString("IS_PRIMARY"), true, layout, c);
    }

    public String checkSettings() {
        try {
            String indicatorText = CustomGraphUI.getIndicatorText(this.getSettings());
            Expression indicator = Parser.parse(indicatorText);
            CustomGraphUI.createCustom(indicator, this.source, this.quoteBundle, this.symbol);
            return null;
        }
        catch (ExpressionException p) {
            return p.getReason();
        }
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(INDICATOR, this.indicatorComboBox.getEquationText());
        settings.put(IS_PRIMARY, this.isPrimaryCheckBox.isSelected() ? "1" : "0");
        return settings;
    }

    public void setSettings(HashMap settings) {
        this.indicatorComboBox.setEquationText(CustomGraphUI.getIndicatorText(settings));
        this.isPrimaryCheckBox.setSelected(this.isPrimaryCheckBox.isSelected());
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static String getIndicatorText(HashMap settings) {
        String indicator = (String)settings.get(INDICATOR);
        if (indicator == null) {
            indicator = "";
        }
        return indicator;
    }

    public static Graphable createCustom(Expression indicator, Graphable source, QuoteBundle quoteBundle, Symbol symbol) throws EvaluationException {
        Graphable indicatorGraphable = new Graphable();
        double[] values = source.toArray();
        Set xRange = source.getXRange();
        Iterator iterator = xRange.iterator();
        Variables variables = new Variables();
        while (iterator.hasNext()) {
            TradingDate date = (TradingDate)iterator.next();
            try {
                int dateOffset = quoteBundle.dateToOffset(date);
                double value = indicator.evaluate(variables, quoteBundle, symbol, dateOffset);
                indicatorGraphable.putY(date, new Double(value));
            }
            catch (WeekendDateException e) {}
        }
        return indicatorGraphable;
    }

    public static boolean isPrimary(HashMap settings) {
        String isPrimary = (String)settings.get(IS_PRIMARY);
        return isPrimary.equals("1");
    }
}

