/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class ExpMovingAverageGraphUI
implements GraphUI {
    private JPanel panel;
    private JTextField periodTextField;
    private JTextField smoothingConstantTextField;
    private static final String PERIOD = "period";
    private static final String SMOOTHING_CONSTANT = "smoothing_constant";
    private static final int MINIMUM_PERIOD = 2;
    private static final double MINIMUM_SMOOTHING_CONSTANT = 0.01;
    private static final double MAXIMUM_SMOOTHING_CONSTANT = 1.0;
    private static final int DEFAULT_PERIOD = 40;
    private static final double DEFAULT_SMOOTHING_CONSTANT = 0.1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExpMovingAverageGraphUI(HashMap settings) {
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.periodTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("PERIOD"), "", layout, c, 8);
        this.smoothingConstantTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("SMOOTHING_CONSTANT"), "", layout, c, 8);
    }

    public String checkSettings() {
        double smoothingConstant;
        int period;
        HashMap settings = this.getSettings();
        String periodString = (String)settings.get(PERIOD);
        try {
            period = Integer.parseInt(periodString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", periodString);
        }
        if (period < 2) {
            return Locale.getString("PERIOD_TOO_SMALL");
        }
        String smoothingConstantString = (String)settings.get(SMOOTHING_CONSTANT);
        try {
            smoothingConstant = Double.parseDouble(smoothingConstantString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", smoothingConstantString);
        }
        if (smoothingConstant < 0.01 || smoothingConstant > 1.0) {
            return Locale.getString("ERROR_SMOOTHING_CONSTANT", 0.01, 1.0);
        }
        return null;
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PERIOD, this.periodTextField.getText());
        settings.put(SMOOTHING_CONSTANT, this.smoothingConstantTextField.getText());
        return settings;
    }

    public void setSettings(HashMap settings) {
        this.periodTextField.setText(Integer.toString(ExpMovingAverageGraphUI.getPeriod(settings)));
        this.smoothingConstantTextField.setText(Double.toString(ExpMovingAverageGraphUI.getSmoothingConstant(settings)));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static int getPeriod(HashMap settings) {
        int period;
        block3: {
            period = 40;
            String periodString = (String)settings.get(PERIOD);
            if (periodString != null) {
                try {
                    period = Integer.parseInt(periodString);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return period;
    }

    public static double getSmoothingConstant(HashMap settings) {
        double smoothingConstant;
        block3: {
            smoothingConstant = 0.1;
            String text = (String)settings.get(SMOOTHING_CONSTANT);
            if (text != null) {
                try {
                    smoothingConstant = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return smoothingConstant;
    }

    static {
        $assertionsDisabled = !ExpMovingAverageGraphUI.class.desiredAssertionStatus();
    }
}

