/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.source.GraphSource;

public class LineGraph
extends AbstractGraph {
    private String name;
    private boolean isPrimary;

    public LineGraph(GraphSource source, String name, boolean isPrimary) {
        super(source);
        this.name = name;
        this.isPrimary = isPrimary;
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(colour);
        GraphTools.renderLine(g, this.getSource().getGraphable(), xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int yCoordinate, int yoffset, double verticalScale, double bottomLineValue) {
        int yOfGraph;
        Double y = this.getY(x);
        if (y != null && Math.abs(yCoordinate - (yOfGraph = yoffset - GraphTools.scaleAndFitPoint(y, bottomLineValue, verticalScale))) < 50) {
            return this.getSource().getToolTipText(x);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }
}

