/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.ExpMovingAverageGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.MACDGraphUI;
import org.mov.chart.graph.MovingAverageGraph;
import org.mov.chart.source.GraphSource;
import org.mov.util.Locale;

public class MACDGraph
extends AbstractGraph {
    private Graphable fastMovingAverage;
    private Graphable slowMovingAverage;

    public MACDGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    private void createMACDGraph(Graphable source, int periodOne, int periodTwo, double smoothingConstantOne, double smoothingConstantTwo) {
        int slowPeriod = Math.max(periodOne, periodTwo);
        int fastPeriod = Math.min(periodOne, periodTwo);
        if (periodOne > periodTwo) {
            this.slowMovingAverage = ExpMovingAverageGraph.createMovingAverage(source, periodOne, smoothingConstantOne);
            this.fastMovingAverage = ExpMovingAverageGraph.createMovingAverage(source, periodTwo, smoothingConstantTwo);
        } else {
            this.slowMovingAverage = ExpMovingAverageGraph.createMovingAverage(source, periodTwo, smoothingConstantTwo);
            this.fastMovingAverage = ExpMovingAverageGraph.createMovingAverage(source, periodOne, smoothingConstantOne);
        }
    }

    private void createMACDGraph(Graphable source, int periodOne, int periodTwo) {
        int slowPeriod = Math.max(periodOne, periodTwo);
        int fastPeriod = Math.min(periodOne, periodTwo);
        this.slowMovingAverage = MovingAverageGraph.createMovingAverage(source, slowPeriod);
        this.fastMovingAverage = MovingAverageGraph.createMovingAverage(source, fastPeriod);
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List dates) {
        g.setColor(Color.green.darker());
        GraphTools.renderLine(g, this.fastMovingAverage, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, dates);
        g.setColor(Color.red.darker());
        GraphTools.renderLine(g, this.slowMovingAverage, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, dates);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        double slowHighestY;
        double fastHighestY = this.fastMovingAverage.getHighestY(x);
        return fastHighestY > (slowHighestY = this.slowMovingAverage.getHighestY(x)) ? fastHighestY : slowHighestY;
    }

    public double getLowestY(List x) {
        double slowLowestY;
        double fastLowestY = this.fastMovingAverage.getLowestY(x);
        return fastLowestY < (slowLowestY = this.slowMovingAverage.getLowestY(x)) ? fastLowestY : slowLowestY;
    }

    public String getName() {
        return Locale.getString("MACD");
    }

    public boolean isPrimary() {
        return true;
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        String averageType = MACDGraphUI.getAverageType(settings);
        int periodFirstAverage = MACDGraphUI.getPeriodFirstAverage(settings);
        int periodSecondAverage = MACDGraphUI.getPeriodSecondAverage(settings);
        double smoothingConstantFirstAverage = MACDGraphUI.getSmoothingConstantFirstAverage(settings);
        double smoothingConstantSecondAverage = MACDGraphUI.getSmoothingConstantSecondAverage(settings);
        if (averageType.compareTo("SMA") == 0) {
            this.createMACDGraph(this.getSource().getGraphable(), periodFirstAverage, periodSecondAverage);
        } else {
            this.createMACDGraph(this.getSource().getGraphable(), periodFirstAverage, periodSecondAverage, smoothingConstantFirstAverage, smoothingConstantSecondAverage);
        }
    }

    public GraphUI getUI(HashMap settings) {
        return new MACDGraphUI(settings);
    }
}

