/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class MACDGraphUI
implements GraphUI {
    private static final String AVERAGE_TYPE = "MACD average type";
    public static final String SMA = "SMA";
    public static final String EMA = "EMA";
    private static final String PERIOD_FIRST_AVERAGE = "MACD period first";
    private static final String PERIOD_SECOND_AVERAGE = "MACD period second";
    private static final String SMOOTHING_CONSTANT_FIRST_AVERAGE = "MACD smooth first";
    private static final String SMOOTHING_CONSTANT_SECOND_AVERAGE = "MACD smooth second";
    private static final int MINIMUM_PERIOD = 2;
    private static final double MINIMUM_SMOOTHING_CONSTANT = 0.01;
    private static final double MAXIMUM_SMOOTHING_CONSTANT = 1.0;
    private static final String DEFAULT_AVERAGE = "EMA";
    private static final int DEFAULT_PERIOD_FIRST_AVERAGE = 26;
    private static final int DEFAULT_PERIOD_SECOND_AVERAGE = 12;
    private static final double DEFAULT_SMOOTHING_CONSTANT = 0.1;
    private JPanel panel;
    private JPanel panelTextBoxes;
    private ButtonGroup group = new ButtonGroup();
    private JRadioButton[] radioButtons = new JRadioButton[2];
    private String actualAverage = "EMA";
    private JTextField periodFirstAverageTextField;
    private JTextField periodSecondAverageTextField;
    private JTextField smoothingConstantFirstAverageTextField;
    private JTextField smoothingConstantSecondAverageTextField;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MACDGraphUI(HashMap settings) {
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panelTextBoxes = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panelTextBoxes.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.radioButtons[0] = new JRadioButton(Locale.getString("EXP_MOVING_AVERAGE"));
        this.radioButtons[0].setActionCommand("EMA");
        this.group.add(this.radioButtons[0]);
        this.radioButtons[0].setAlignmentX(0.0f);
        this.panel.add(this.radioButtons[0]);
        this.radioButtons[1] = new JRadioButton(Locale.getString("SIMPLE_MOVING_AVERAGE"));
        this.radioButtons[1].setActionCommand(SMA);
        this.group.add(this.radioButtons[1]);
        this.radioButtons[1].setAlignmentX(0.0f);
        this.panel.add(this.radioButtons[1]);
        this.periodFirstAverageTextField = GridBagHelper.addTextRow(this.panelTextBoxes, Locale.getString("PERIOD_FIRST_AVERAGE"), "", layout, c, 8);
        this.smoothingConstantFirstAverageTextField = GridBagHelper.addTextRow(this.panelTextBoxes, Locale.getString("SMOOTHING_CONSTANT_FIRST_AVERAGE"), "", layout, c, 8);
        this.periodSecondAverageTextField = GridBagHelper.addTextRow(this.panelTextBoxes, Locale.getString("PERIOD_SECOND_AVERAGE"), "", layout, c, 8);
        this.smoothingConstantSecondAverageTextField = GridBagHelper.addTextRow(this.panelTextBoxes, Locale.getString("SMOOTHING_CONSTANT_SECOND_AVERAGE"), "", layout, c, 8);
        this.panelTextBoxes.setAlignmentX(0.0f);
        this.panel.add(this.panelTextBoxes);
        this.radioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MACDGraphUI.this.actualAverage = MACDGraphUI.this.group.getSelection().getActionCommand();
                MACDGraphUI.this.smoothingConstantFirstAverageTextField.setEnabled(true);
                MACDGraphUI.this.smoothingConstantSecondAverageTextField.setEnabled(true);
            }
        });
        this.radioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MACDGraphUI.this.actualAverage = MACDGraphUI.this.group.getSelection().getActionCommand();
                MACDGraphUI.this.smoothingConstantFirstAverageTextField.setEnabled(false);
                MACDGraphUI.this.smoothingConstantSecondAverageTextField.setEnabled(false);
            }
        });
    }

    public String checkSettings() {
        double smoothingConstant;
        int period;
        HashMap settings = this.getSettings();
        String periodFirstAverageString = (String)settings.get(PERIOD_FIRST_AVERAGE);
        String periodSecondAverageString = (String)settings.get(PERIOD_SECOND_AVERAGE);
        try {
            period = Integer.parseInt(periodFirstAverageString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", periodFirstAverageString);
        }
        if (period < 2) {
            return Locale.getString("PERIOD_TOO_SMALL");
        }
        try {
            period = Integer.parseInt(periodSecondAverageString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", periodSecondAverageString);
        }
        if (period < 2) {
            return Locale.getString("PERIOD_TOO_SMALL");
        }
        String smoothingFirstAverageConstantString = (String)settings.get(SMOOTHING_CONSTANT_FIRST_AVERAGE);
        String smoothingSecondAverageConstantString = (String)settings.get(SMOOTHING_CONSTANT_FIRST_AVERAGE);
        try {
            smoothingConstant = Double.parseDouble(smoothingFirstAverageConstantString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", smoothingFirstAverageConstantString);
        }
        if (smoothingConstant < 0.01 || smoothingConstant > 1.0) {
            return Locale.getString("ERROR_SMOOTHING_CONSTANT", 0.01, 1.0);
        }
        try {
            smoothingConstant = Double.parseDouble(smoothingSecondAverageConstantString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", smoothingSecondAverageConstantString);
        }
        if (smoothingConstant < 0.01 || smoothingConstant > 1.0) {
            return Locale.getString("ERROR_SMOOTHING_CONSTANT", 0.01, 1.0);
        }
        return null;
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(AVERAGE_TYPE, this.actualAverage);
        settings.put(PERIOD_FIRST_AVERAGE, this.periodFirstAverageTextField.getText());
        settings.put(PERIOD_SECOND_AVERAGE, this.periodSecondAverageTextField.getText());
        settings.put(SMOOTHING_CONSTANT_FIRST_AVERAGE, this.smoothingConstantFirstAverageTextField.getText());
        settings.put(SMOOTHING_CONSTANT_SECOND_AVERAGE, this.smoothingConstantSecondAverageTextField.getText());
        return settings;
    }

    public void setSettings(HashMap settings) {
        this.actualAverage = MACDGraphUI.getAverageType(settings);
        if (this.actualAverage.compareTo("EMA") == 0) {
            this.radioButtons[0].setSelected(true);
        }
        if (this.actualAverage.compareTo(SMA) == 0) {
            this.radioButtons[1].setSelected(true);
        }
        this.periodFirstAverageTextField.setText(Integer.toString(MACDGraphUI.getPeriodFirstAverage(settings)));
        this.periodSecondAverageTextField.setText(Integer.toString(MACDGraphUI.getPeriodSecondAverage(settings)));
        this.smoothingConstantFirstAverageTextField.setText(Double.toString(MACDGraphUI.getSmoothingConstantFirstAverage(settings)));
        this.smoothingConstantSecondAverageTextField.setText(Double.toString(MACDGraphUI.getSmoothingConstantSecondAverage(settings)));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static String getAverageType(HashMap settings) {
        String averageType = "EMA";
        String averageTypeSaved = (String)settings.get(AVERAGE_TYPE);
        if (averageTypeSaved != null) {
            averageType = averageTypeSaved;
        }
        return averageType;
    }

    public static int getPeriodFirstAverage(HashMap settings) {
        int period;
        block3: {
            period = 26;
            String text = (String)settings.get(PERIOD_FIRST_AVERAGE);
            if (text != null) {
                try {
                    period = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return period;
    }

    public static double getSmoothingConstantFirstAverage(HashMap settings) {
        double smoothingConstant;
        block3: {
            smoothingConstant = 0.1;
            String text = (String)settings.get(SMOOTHING_CONSTANT_FIRST_AVERAGE);
            if (text != null) {
                try {
                    smoothingConstant = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return smoothingConstant;
    }

    public static int getPeriodSecondAverage(HashMap settings) {
        int period;
        block3: {
            period = 12;
            String text = (String)settings.get(PERIOD_SECOND_AVERAGE);
            if (text != null) {
                try {
                    period = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return period;
    }

    public static double getSmoothingConstantSecondAverage(HashMap settings) {
        double smoothingConstant;
        block3: {
            smoothingConstant = 0.1;
            String text = (String)settings.get(SMOOTHING_CONSTANT_SECOND_AVERAGE);
            if (text != null) {
                try {
                    smoothingConstant = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return smoothingConstant;
    }

    static {
        $assertionsDisabled = !MACDGraphUI.class.desiredAssertionStatus();
    }
}

