/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.PeriodGraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.util.Locale;

public class MomentumGraph
extends AbstractGraph {
    private Graphable momentum;

    public MomentumGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(colour);
        GraphTools.renderBar(g, this.momentum, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return Math.max(Math.abs(this.momentum.getHighestY(x)), Math.abs(this.momentum.getLowestY(x)));
    }

    public double getLowestY(List x) {
        return -this.getHighestY(x);
    }

    public double[] getAcceptableMajorDeltas() {
        double[] major = new double[]{0.01, 0.1, 1.0, 10.0, 100.0, 1000.0};
        return major;
    }

    public double[] getAcceptableMinorDeltas() {
        double[] minor = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        return minor;
    }

    public String getYLabel(double value) {
        return Double.toString(value);
    }

    public static Graphable createMomentum(Graphable source, int period) {
        Graphable momentum = new Graphable();
        double[] values = source.toArray();
        Iterator iterator = source.getXRange().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            double todaysMomentum = values[i] - values[Math.max(1 + i - period, 0)];
            momentum.putY(x, new Double(todaysMomentum));
            ++i;
        }
        return momentum;
    }

    public String getName() {
        return Locale.getString("MOMENTUM");
    }

    public boolean isPrimary() {
        return false;
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        int period = PeriodGraphUI.getPeriod(settings);
        this.momentum = MomentumGraph.createMomentum(this.getSource().getGraphable(), period);
    }

    public GraphUI getUI(HashMap settings) {
        return new PeriodGraphUI(settings);
    }
}

