/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.GraphableQuoteFunctionSource;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.PeriodGraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.parser.EvaluationException;
import org.mov.quote.QuoteFunctions;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class MovingAverageGraph
extends AbstractGraph {
    private Graphable movingAverage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MovingAverageGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(Color.green.darker());
        GraphTools.renderLine(g, this.movingAverage, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return this.movingAverage.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.movingAverage.getLowestY(x);
    }

    public static Graphable createMovingAverage(Graphable source, int period) {
        Graphable movingAverage = new Graphable();
        TradingDate date = (TradingDate)source.getStartX();
        GraphableQuoteFunctionSource quoteFunctionSource = new GraphableQuoteFunctionSource(source, date, period);
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            date = (TradingDate)iterator.next();
            quoteFunctionSource.setDate(date);
            try {
                double average = QuoteFunctions.avg(quoteFunctionSource, period);
                movingAverage.putY(date, new Double(average));
            }
            catch (EvaluationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }
        return movingAverage;
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        int period = PeriodGraphUI.getPeriod(settings);
        this.movingAverage = MovingAverageGraph.createMovingAverage(this.getSource().getGraphable(), period);
    }

    public GraphUI getUI(HashMap settings) {
        return new PeriodGraphUI(settings);
    }

    public String getName() {
        return Locale.getString("SIMPLE_MOVING_AVERAGE");
    }

    public boolean isPrimary() {
        return true;
    }

    static {
        $assertionsDisabled = !MovingAverageGraph.class.desiredAssertionStatus();
    }
}

