/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.source.GraphSource;
import org.mov.util.Locale;

public class OBVGraph
extends AbstractGraph {
    private static final double INITIAL_VALUE = 50000.0;
    private Graphable obv;

    public OBVGraph(GraphSource open, GraphSource close, GraphSource volume) {
        super(volume);
        this.obv = OBVGraph.createOBV(open.getGraphable(), close.getGraphable(), volume.getGraphable());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(colour);
        GraphTools.renderLine(g, this.obv, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return this.obv.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.obv.getLowestY(x);
    }

    public static Graphable createOBV(Graphable open, Graphable close, Graphable volume) {
        double runningOBV = 50000.0;
        Graphable obv = new Graphable();
        Iterator iterator = open.getXRange().iterator();
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            Double dayOpen = open.getY(x);
            Double dayClose = close.getY(x);
            Double dayVolume = volume.getY(x);
            if (dayClose.compareTo(dayOpen) > 0) {
                runningOBV += (double)dayVolume.intValue();
            } else if (dayClose.compareTo(dayOpen) < 0) {
                runningOBV -= (double)dayVolume.intValue();
            }
            obv.putY(x, new Double(runningOBV));
        }
        return obv;
    }

    public String getName() {
        return Locale.getString("OBV");
    }

    public boolean isPrimary() {
        return false;
    }
}

