/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class PeriodGraphUI
implements GraphUI {
    private JPanel panel;
    private JTextField periodTextField;
    private static final String PERIOD = "period";
    private static final int MINIMUM_PERIOD = 2;
    private static final int DEFAULT_PERIOD = 21;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PeriodGraphUI(HashMap settings) {
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.periodTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("PERIOD"), "", layout, c, 8);
    }

    public String checkSettings() {
        int period;
        HashMap settings = this.getSettings();
        String periodString = (String)settings.get(PERIOD);
        try {
            period = Integer.parseInt(periodString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", periodString);
        }
        if (period < 2) {
            return Locale.getString("PERIOD_TOO_SMALL");
        }
        return null;
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PERIOD, this.periodTextField.getText());
        return settings;
    }

    public void setSettings(HashMap settings) {
        int period = PeriodGraphUI.getPeriod(settings);
        this.periodTextField.setText(Integer.toString(period));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static int getPeriod(HashMap settings) {
        int period;
        block3: {
            period = 21;
            String periodString = (String)settings.get(PERIOD);
            if (periodString != null) {
                try {
                    period = Integer.parseInt(periodString);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return period;
    }

    static {
        $assertionsDisabled = !PeriodGraphUI.class.desiredAssertionStatus();
    }
}

