/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.PFGraphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.PointAndFigureGraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.quote.QuoteFunctions;
import org.mov.util.Locale;

public class PointAndFigureGraph
extends AbstractGraph {
    private PFGraphable pointAndFigure;

    public PointAndFigureGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(Color.green.darker());
        GraphTools.renderChar(g, this.pointAndFigure, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public double getHighestY(List x) {
        return this.pointAndFigure.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.pointAndFigure.getLowestY(x);
    }

    public String getName() {
        return Locale.getString("POINT_AND_FIGURE");
    }

    public static PFGraphable createPointAndFigureGraph(Graphable source, double priceReversalScale, double boxPriceScale) {
        PFGraphable pointAndFigure = new PFGraphable();
        double[] values = source.toArray();
        Vector<Double> yList = new Vector<Double>();
        Set xRange = source.getXRange();
        Set column = source.getXRange();
        Iterator iterator = xRange.iterator();
        Iterator iterator2 = column.iterator();
        double prev = 0.0;
        boolean upmove = true;
        boolean changeDirection = false;
        int i = 0;
        upmove = PointAndFigureGraph.getFirstDirection(source, boxPriceScale);
        Comparable col = (Comparable)iterator2.next();
        while (iterator.hasNext()) {
            boolean plot;
            Comparable x = (Comparable)iterator.next();
            double diff = i == 0 ? 0.0 : values[i] - prev;
            boolean bl = plot = Math.abs(diff) >= boxPriceScale;
            if (plot) {
                changeDirection = Math.abs(diff) >= priceReversalScale ? (upmove && diff < 0.0 ? true : !upmove && diff > 0.0) : false;
                if (changeDirection) {
                    yList = new Vector();
                    upmove = !upmove;
                    col = (Comparable)iterator2.next();
                }
                String marker = upmove ? "X" : "O";
                diff = Math.abs(diff) - boxPriceScale;
                int counter = 1;
                if (prev != 0.0) {
                    while (diff >= 0.0) {
                        double tmp = upmove ? values[i] - boxPriceScale * (double)counter : values[i] + boxPriceScale * (double)counter;
                        Double yTemp = new Double(tmp);
                        yList.add(yTemp);
                        diff = Math.abs(diff) - boxPriceScale;
                        ++counter;
                    }
                }
                Double yTemp = new Double(values[i]);
                yList.add(yTemp);
                pointAndFigure.putYList(col, yList);
                pointAndFigure.putString(col, marker);
            }
            if (plot) {
                prev = values[i];
            }
            ++i;
        }
        return pointAndFigure;
    }

    public boolean isPrimary() {
        return true;
    }

    private double calculateDefaultPriceReversalScale() {
        Graphable graphable = this.getSource().getGraphable();
        double[] values = graphable.toArray();
        double defaultPriceReversalScale = this.calculateDefaultBoxPriceScale() * 3.0;
        defaultPriceReversalScale = QuoteFunctions.roundDouble(defaultPriceReversalScale, 2);
        return defaultPriceReversalScale;
    }

    private double calculateDefaultBoxPriceScale() {
        Graphable graphable = this.getSource().getGraphable();
        double[] values = graphable.toArray();
        double defaultBoxPriceScale = values[values.length - 1] / 100.0;
        if ((defaultBoxPriceScale = QuoteFunctions.roundDouble(defaultBoxPriceScale, 2)) <= 0.0) {
            defaultBoxPriceScale = 0.01;
        }
        return defaultBoxPriceScale;
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        double defaultPriceReversalScale = this.calculateDefaultPriceReversalScale();
        double defaultBoxPriceScale = this.calculateDefaultBoxPriceScale();
        double priceReversalScale = PointAndFigureGraphUI.getPriceReversalScale(settings, defaultPriceReversalScale);
        double boxPriceScale = PointAndFigureGraphUI.getBoxPriceScale(settings, defaultBoxPriceScale);
        this.pointAndFigure = PointAndFigureGraph.createPointAndFigureGraph(this.getSource().getGraphable(), priceReversalScale, boxPriceScale);
    }

    public GraphUI getUI(HashMap settings) {
        return new PointAndFigureGraphUI(settings, this.calculateDefaultPriceReversalScale(), this.calculateDefaultBoxPriceScale());
    }

    private static boolean getFirstDirection(Graphable source, double boxValue) {
        Set xRange = source.getXRange();
        Iterator iterator = xRange.iterator();
        double prev = 0.0;
        int i = 0;
        double[] values = source.toArray();
        while (iterator.hasNext()) {
            double diff;
            Comparable x = (Comparable)iterator.next();
            double d = diff = i <= 1 ? 0.0 : values[i] - prev;
            if (Math.abs(diff) >= boxValue) {
                prev = values[i];
            }
            ++i;
            if (!(Math.abs(diff) >= boxValue)) continue;
            if (diff > 0.0) {
                return true;
            }
            if (!(diff < 0.0)) continue;
            return false;
        }
        return true;
    }
}

