/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class PointAndFigureGraphUI
implements GraphUI {
    private JPanel panel;
    private JTextField priceReversalTextField;
    private JTextField boxPriceTextField;
    private static final String PRICE_REVERSAL_SCALE = "price_reversal_scale";
    private static final String BOX_PRICE_SCALE = "box_price";
    private static final double MINIMUM_PRICE_SCALE = 1.0E-4;
    private double defaultPriceReversalScale;
    private double defaultBoxPriceScale;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PointAndFigureGraphUI(HashMap settings, double defaultPriceReversalScale, double defaultBoxPriceScale) {
        this.defaultPriceReversalScale = defaultPriceReversalScale;
        this.defaultBoxPriceScale = defaultBoxPriceScale;
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.priceReversalTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("PRICE_REVERSAL_SCALE"), "", layout, c, 8);
        this.boxPriceTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("BOX_PRICE_SCALE"), "", layout, c, 8);
    }

    public String checkSettings() {
        double boxPriceScale;
        double priceReversalScale;
        HashMap settings = this.getSettings();
        String priceReversalScaleString = (String)settings.get(PRICE_REVERSAL_SCALE);
        String boxPriceScaleString = (String)settings.get(BOX_PRICE_SCALE);
        try {
            priceReversalScale = Double.parseDouble(priceReversalScaleString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", priceReversalScaleString);
        }
        try {
            boxPriceScale = Double.parseDouble(boxPriceScaleString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", boxPriceScaleString);
        }
        if (priceReversalScale < 1.0E-4) {
            return Locale.getString("ERROR_PRICE_SCALE_TOO_SMALL");
        }
        if (boxPriceScale < 1.0E-4) {
            return Locale.getString("ERROR_PRICE_SCALE_TOO_SMALL");
        }
        return null;
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PRICE_REVERSAL_SCALE, this.priceReversalTextField.getText());
        settings.put(BOX_PRICE_SCALE, this.boxPriceTextField.getText());
        return settings;
    }

    public void setSettings(HashMap settings) {
        this.priceReversalTextField.setText(Double.toString(PointAndFigureGraphUI.getPriceReversalScale(settings, this.defaultPriceReversalScale)));
        this.boxPriceTextField.setText(Double.toString(PointAndFigureGraphUI.getBoxPriceScale(settings, this.defaultBoxPriceScale)));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static double getPriceReversalScale(HashMap settings, double defaultPriceReversalScale) {
        double priceReversalScale;
        block3: {
            priceReversalScale = defaultPriceReversalScale;
            String priceReversalScaleString = (String)settings.get(PRICE_REVERSAL_SCALE);
            if (priceReversalScaleString != null) {
                try {
                    priceReversalScale = Double.parseDouble(priceReversalScaleString);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return priceReversalScale;
    }

    public static double getBoxPriceScale(HashMap settings, double defaultBoxPrice) {
        double boxPriceScale;
        block3: {
            boxPriceScale = defaultBoxPrice;
            String boxPriceScaleString = (String)settings.get(BOX_PRICE_SCALE);
            if (boxPriceScaleString != null) {
                try {
                    boxPriceScale = Double.parseDouble(boxPriceScaleString);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return boxPriceScale;
    }

    static {
        $assertionsDisabled = !PointAndFigureGraphUI.class.desiredAssertionStatus();
    }
}

