/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.GraphableQuoteFunctionSource;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.graph.GraphUI;
import org.mov.chart.graph.RSIGraphUI;
import org.mov.chart.source.GraphSource;
import org.mov.parser.EvaluationException;
import org.mov.quote.QuoteFunctions;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class RSIGraph
extends AbstractGraph {
    private Graphable RSI;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RSIGraph(GraphSource source) {
        super(source);
        this.setSettings(new HashMap());
    }

    public void render(Graphics g, Color colour, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        int overSold = RSIGraphUI.getOverSold(this.getSettings());
        int overBought = RSIGraphUI.getOverBought(this.getSettings());
        g.setColor(Color.BLACK);
        GraphTools.renderHorizontalLine(g, overSold, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
        GraphTools.renderHorizontalLine(g, overBought, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
        g.setColor(colour);
        GraphTools.renderLine(g, this.RSI, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return 100.0;
    }

    public double getLowestY(List x) {
        return 0.0;
    }

    public double[] getAcceptableMajorDeltas() {
        double[] major = new double[]{0.1, 0.5, 1.0, 10.0, 100.0};
        return major;
    }

    public double[] getAcceptableMinorDeltas() {
        double[] minor = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        return minor;
    }

    public String getYLabel(double value) {
        return Double.toString(value);
    }

    public static Graphable createRSI(Graphable source, int period) {
        Graphable RSI = new Graphable();
        TradingDate date = (TradingDate)source.getStartX();
        GraphableQuoteFunctionSource quoteFunctionSource = new GraphableQuoteFunctionSource(source, date, period + 1);
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            date = (TradingDate)iterator.next();
            quoteFunctionSource.setDate(date);
            try {
                double rsi = QuoteFunctions.rsi(quoteFunctionSource, period + 1);
                RSI.putY(date, new Double(rsi));
            }
            catch (EvaluationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }
        return RSI;
    }

    public String getName() {
        return Locale.getString("RSI");
    }

    public boolean isPrimary() {
        return false;
    }

    public void setSettings(HashMap settings) {
        super.setSettings(settings);
        int period = RSIGraphUI.getPeriod(settings);
        this.RSI = RSIGraph.createRSI(this.getSource().getGraphable(), period);
    }

    public GraphUI getUI(HashMap settings) {
        return new RSIGraphUI(settings);
    }

    static {
        $assertionsDisabled = !RSIGraph.class.desiredAssertionStatus();
    }
}

