/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mov.chart.graph.GraphUI;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class RSIGraphUI
implements GraphUI {
    private JPanel panel;
    private JTextField periodTextField;
    private JTextField overSoldTextField;
    private JTextField overBoughtTextField;
    private static final String PERIOD = "period";
    private static final String OVER_SOLD = "oversold";
    private static final String OVER_BOUGHT = "overbought";
    private static final int MINIMUM_PERIOD = 2;
    private static final int MINIMUM_OVER_SOLD = 1;
    private static final int MAXIMUM_OVER_SOLD = 49;
    private static final int MINIMUM_OVER_BOUGHT = 51;
    private static final int MAXIMUM_OVER_BOUGHT = 99;
    private static final int DEFAULT_PERIOD = 14;
    private static final int DEFAULT_OVER_SOLD = 32;
    private static final int DEFAULT_OVER_BOUGHT = 72;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RSIGraphUI(HashMap settings) {
        this.buildPanel();
        this.setSettings(settings);
    }

    private void buildPanel() {
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(layout);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.periodTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("PERIOD"), "", layout, c, 8);
        this.overSoldTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("OVER_SOLD"), "", layout, c, 8);
        this.overBoughtTextField = GridBagHelper.addTextRow(this.panel, Locale.getString("OVER_BOUGHT"), "", layout, c, 8);
    }

    public String checkSettings() {
        int overBought;
        int overSold;
        int period;
        HashMap settings = this.getSettings();
        String periodString = (String)settings.get(PERIOD);
        try {
            period = Integer.parseInt(periodString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", periodString);
        }
        if (period < 2) {
            return Locale.getString("PERIOD_TOO_SMALL");
        }
        String overSoldString = (String)settings.get(OVER_SOLD);
        try {
            overSold = Integer.parseInt(overSoldString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", overSoldString);
        }
        if (overSold < 1 || overSold > 49) {
            return Locale.getString("ERROR_OVER_SOLD_LIMITS", 1, 49);
        }
        String overBoughtString = (String)settings.get(OVER_BOUGHT);
        try {
            overBought = Integer.parseInt(overBoughtString);
        }
        catch (NumberFormatException e) {
            return Locale.getString("ERROR_PARSING_NUMBER", overBoughtString);
        }
        if (overBought < 51 || overBought > 99) {
            return Locale.getString("ERROR_OVER_BOUGHT_LIMITS", 51, 99);
        }
        return null;
    }

    public HashMap getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PERIOD, this.periodTextField.getText());
        settings.put(OVER_SOLD, this.overSoldTextField.getText());
        settings.put(OVER_BOUGHT, this.overBoughtTextField.getText());
        return settings;
    }

    public void setSettings(HashMap settings) {
        this.periodTextField.setText(Integer.toString(RSIGraphUI.getPeriod(settings)));
        this.overSoldTextField.setText(Integer.toString(RSIGraphUI.getOverSold(settings)));
        this.overBoughtTextField.setText(Integer.toString(RSIGraphUI.getOverBought(settings)));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static int getPeriod(HashMap settings) {
        int period;
        block3: {
            period = 14;
            String periodString = (String)settings.get(PERIOD);
            if (periodString != null) {
                try {
                    period = Integer.parseInt(periodString);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return period;
    }

    public static int getOverSold(HashMap settings) {
        int overSold;
        block3: {
            overSold = 32;
            String text = (String)settings.get(OVER_SOLD);
            if (text != null) {
                try {
                    overSold = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return overSold;
    }

    public static int getOverBought(HashMap settings) {
        int overBought;
        block3: {
            overBought = 72;
            String text = (String)settings.get(OVER_BOUGHT);
            if (text != null) {
                try {
                    overBought = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return overBought;
    }

    static {
        $assertionsDisabled = !RSIGraphUI.class.desiredAssertionStatus();
    }
}

