/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mov.chart.GraphTools;
import org.mov.chart.Graphable;
import org.mov.chart.graph.AbstractGraph;
import org.mov.chart.source.GraphSource;
import org.mov.util.Locale;

public class SupportAndResistenceGraph
extends AbstractGraph {
    private Graphable support = new Graphable();
    private Graphable resistence = new Graphable();

    public SupportAndResistenceGraph(GraphSource source) {
        super(source);
        this.createSupportAndResistence(source.getGraphable(), this.support, this.resistence);
    }

    public void render(Graphics g, Color c, int xoffset, int yoffset, double horizontalScale, double verticalScale, double bottomLineValue, List xRange) {
        g.setColor(Color.green.darker());
        GraphTools.renderLine(g, this.support, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
        g.setColor(Color.red.darker());
        GraphTools.renderLine(g, this.resistence, xoffset, yoffset, horizontalScale, verticalScale, bottomLineValue, xRange);
    }

    public String getToolTipText(Comparable x, int y, int yoffset, double verticalScale, double bottomLineValue) {
        return null;
    }

    public double getHighestY(List x) {
        return this.resistence.getHighestY(x);
    }

    public double getLowestY(List x) {
        return this.support.getLowestY(x);
    }

    public String getName() {
        return Locale.getString("SUPPORT_AND_RESISTENCE");
    }

    public boolean isPrimary() {
        return true;
    }

    public Graphable[] createSupportAndResistence(Graphable source, Graphable support, Graphable resistence) {
        int i;
        Graphable[] supportAndResistence = new Graphable[2];
        double[] values = source.toArray();
        double[] peaksPriceData = new double[2];
        double[] troughsPriceData = new double[2];
        int peaksIndex = 0;
        int troughsIndex = 0;
        ArrayList peaksCount = new ArrayList(values.length);
        ArrayList troughsCount = new ArrayList(values.length);
        Set xRange = source.getXRange();
        Iterator iterator = xRange.iterator();
        boolean upmove = false;
        double[] peaks = new double[values.length];
        double[] troughs = new double[values.length];
        double prev = 0.0;
        peaksPriceData[0] = 0.0;
        peaksPriceData[1] = 0.0;
        troughsPriceData[0] = 0.0;
        troughsPriceData[1] = 0.0;
        for (i = 0; i < values.length; ++i) {
            double diff = values[i] - prev;
            if (i == 0) {
                upmove = values[0] - values[1] > 0.0;
            }
            if (i > 0) {
                if (diff > 0.0 && !upmove) {
                    troughs[troughsIndex++] = prev;
                    upmove = true;
                }
                if (diff < 0.0 && upmove) {
                    peaks[peaksIndex++] = prev;
                    upmove = false;
                }
            }
            prev = values[i];
        }
        Arrays.sort(peaks, 0, peaksIndex);
        Arrays.sort(troughs, 0, troughsIndex);
        this.countOccurances(peaksCount, peaks, peaksIndex - 1);
        this.countOccurances(troughsCount, troughs, troughsIndex - 1);
        if (peaksCount.size() > 0) {
            peaksPriceData = (double[])peaksCount.get(peaksCount.size() - 1);
        }
        if (troughsCount.size() > 0) {
            troughsPriceData = (double[])troughsCount.get(troughsCount.size() - 1);
        }
        i = 0;
        while (iterator.hasNext()) {
            Comparable x = (Comparable)iterator.next();
            if (values[i] == peaksPriceData[0]) {
                resistence.putY(x, new Double(values[i]));
            }
            if (values[i] == troughsPriceData[0]) {
                support.putY(x, new Double(values[i]));
            }
            ++i;
        }
        supportAndResistence[0] = support;
        supportAndResistence[0] = resistence;
        return supportAndResistence;
    }

    private void countOccurances(ArrayList list, double[] values, int length) {
        int i;
        int priceIndex = 0;
        double[] priceData = new double[2];
        double prev = 0.0;
        priceData[0] = 0.0;
        priceData[1] = 0.0;
        for (i = 0; i < length - 3; ++i) {
            if (prev != values[i]) {
                if (i > 0) {
                    double[] tmp = new double[]{priceData[0], priceData[1]};
                    list.add(priceIndex++, tmp);
                }
                priceData[0] = values[i];
                priceData[1] = 0.0;
            } else {
                priceData[1] = priceData[1] + 1.0;
            }
            prev = values[i];
        }
        if (length > 0 && values[i - 1] == prev) {
            list.add(priceIndex, priceData);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object a, Object b) {
                double[] v1 = (double[])a;
                double[] v2 = (double[])b;
                if (v1[1] < v2[1]) {
                    return -1;
                }
                if (v1[1] > v2[1]) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

