/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.source;

import org.mov.chart.Graphable;
import org.mov.chart.source.GraphSource;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.ui.QuoteFormat;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class OHLCVQuoteGraphSource
implements GraphSource {
    private QuoteBundle quoteBundle;
    private int quote;
    private Symbol symbol;
    private Graphable graphable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OHLCVQuoteGraphSource(QuoteBundle quoteBundle, int quote) {
        this.quote = quote;
        this.quoteBundle = quoteBundle;
        this.symbol = quoteBundle.getFirstSymbol();
        this.graphable = new Graphable();
        TradingDate date = quoteBundle.getFirstDate();
        while (date.compareTo(quoteBundle.getLastDate()) <= 0) {
            try {
                Double value = new Double(quoteBundle.getQuote(this.symbol, quote, date));
                this.graphable.putY(date, value);
            }
            catch (MissingQuoteException e) {
                // empty catch block
            }
            date = date.next(1);
        }
        if (!$assertionsDisabled && this.graphable.getXRange().size() <= 0) {
            throw new AssertionError();
        }
    }

    public Graphable getGraphable() {
        return this.graphable;
    }

    public String getName() {
        return this.symbol.toString();
    }

    public String getToolTipText(Comparable x) {
        TradingDate date = (TradingDate)x;
        try {
            if (this.quote == 4) {
                return new String("<html>" + this.symbol + ", " + date.toLongString() + "<p>" + Math.round(this.quoteBundle.getQuote(this.symbol, 4, date)) + "</html>");
            }
            double dayLow = this.quoteBundle.getQuote(this.symbol, 2, date);
            double dayHigh = this.quoteBundle.getQuote(this.symbol, 3, date);
            double dayOpen = this.quoteBundle.getQuote(this.symbol, 1, date);
            double dayClose = this.quoteBundle.getQuote(this.symbol, 0, date);
            return new String("<html>" + this.symbol + ", " + date.toLongString() + "<p>" + "<font color=red>" + QuoteFormat.quoteToString(dayLow) + " </font>" + "<font color=green>" + QuoteFormat.quoteToString(dayHigh) + " </font>" + QuoteFormat.quoteToString(dayOpen) + " " + QuoteFormat.quoteToString(dayClose) + "</html>");
        }
        catch (MissingQuoteException e) {
            return null;
        }
    }

    public String getYLabel(double value) {
        if (this.quote == 4) {
            double BILLION = 1.0E9;
            double MILLION = 1000000.0;
            String extension = "";
            if (Math.abs(value) >= 1.0E9) {
                value /= 1.0E9;
                extension = "B";
            } else if (Math.abs(value) >= 1000000.0) {
                value /= 1000000.0;
                extension = "M";
            }
            return Integer.toString((int)value) + extension;
        }
        return Money.toString(value);
    }

    public double[] getAcceptableMajorDeltas() {
        if (this.quote == 4) {
            double[] major = new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
            return major;
        }
        double[] major = new double[]{0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0};
        return major;
    }

    public double[] getAcceptableMinorDeltas() {
        if (this.quote == 4) {
            double[] minor = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0};
            return minor;
        }
        double[] minor = new double[]{1.0, 1.1, 1.25, 1.3333, 1.5, 2.0, 2.25, 2.5, 3.0, 3.3333, 4.0, 5.0, 6.0, 6.5, 7.0, 7.5, 8.0, 9.0};
        return minor;
    }

    static {
        $assertionsDisabled = !OHLCVQuoteGraphSource.class.desiredAssertionStatus();
    }
}

