/*
 * Decompiled with CFR 0.152.
 */
package org.mov.chart.source;

import java.util.Iterator;
import java.util.List;
import org.mov.chart.Graphable;
import org.mov.chart.source.GraphSource;
import org.mov.portfolio.Account;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class PortfolioGraphSource
implements GraphSource {
    public static final int MARKET_VALUE = 0;
    public static final int RETURN_VALUE = 1;
    public static final int CASH_VALUE = 2;
    public static final int SHARE_VALUE = 3;
    public static final int STOCKS_HELD = 4;
    private static final int ACCOUNT_VALUE = 5;
    private QuoteBundle quoteBundle;
    private int mode;
    private Graphable graphable;
    private Portfolio portfolio;
    private String accountName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortfolioGraphSource(Portfolio portfolio, QuoteBundle quoteBundle, int mode) {
        this.portfolio = portfolio;
        this.quoteBundle = quoteBundle;
        this.mode = mode;
        this.accountName = null;
        this.createGraphable();
    }

    public PortfolioGraphSource(Portfolio portfolio, QuoteBundle quoteBundle, String accountName) {
        this.portfolio = portfolio;
        this.quoteBundle = quoteBundle;
        this.mode = 5;
        this.accountName = accountName;
        this.createGraphable();
    }

    private void createGraphable() {
        if (this.portfolio.getStartDate() != null) {
            this.graphable = new Graphable();
            List dateRange = TradingDate.dateRangeToList(this.portfolio.getStartDate(), this.quoteBundle.getLastDate());
            Iterator portfolioIterator = this.portfolio.iterator();
            Iterator dateIterator = dateRange.iterator();
            while (dateIterator.hasNext()) {
                TradingDate date = (TradingDate)dateIterator.next();
                Portfolio portfolio = (Portfolio)portfolioIterator.next();
                try {
                    Money value;
                    if (this.mode == 0) {
                        value = portfolio.getValue(this.quoteBundle, date);
                    } else if (this.mode == 2) {
                        value = portfolio.getCashValue();
                    } else if (this.mode == 3) {
                        value = portfolio.getShareValue(this.quoteBundle, date);
                    } else if (this.mode == 1) {
                        value = portfolio.getReturnValue(this.quoteBundle, date);
                    } else if (this.mode == 4) {
                        int stocksHeld = portfolio.getStocksHeld().size();
                        value = new Money((double)stocksHeld);
                    } else {
                        if (!$assertionsDisabled && this.mode != 5) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.accountName == null) {
                            throw new AssertionError();
                        }
                        Account account = portfolio.findAccountByName(this.accountName);
                        if (!$assertionsDisabled && account == null) {
                            throw new AssertionError();
                        }
                        value = account.getValue(this.quoteBundle, date);
                    }
                    this.graphable.putY(date, new Double(value.doubleValue()));
                }
                catch (MissingQuoteException e) {}
            }
        } else {
            this.graphable = null;
        }
    }

    public Graphable getGraphable() {
        return this.graphable;
    }

    public String getName() {
        return this.portfolio.getName();
    }

    public String getToolTipText(Comparable x) {
        TradingDate date = (TradingDate)x;
        Double value = this.graphable.getY(x);
        if (value != null) {
            String name = this.portfolio.getName();
            if (this.mode == 1) {
                name = name.concat(" ");
                name = name.concat(Locale.getString("PROFIT"));
            }
            return new String("<html>" + name + ", " + date.toLongString() + "<p>" + this.getYLabel(value));
        }
        return null;
    }

    public String getYLabel(double value) {
        if (this.mode == 4) {
            return Integer.toString((int)value);
        }
        return Money.toString(value);
    }

    public double[] getAcceptableMajorDeltas() {
        if (this.mode == 4) {
            double[] major = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
            return major;
        }
        double[] major = new double[]{0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E9};
        return major;
    }

    public double[] getAcceptableMinorDeltas() {
        if (this.mode == 4) {
            double[] minor = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0};
            return minor;
        }
        double[] minor = new double[]{1.0, 1.1, 1.25, 1.3333, 1.5, 2.0, 2.25, 2.5, 3.0, 3.3333, 4.0, 5.0, 6.0, 6.5, 7.0, 7.5, 8.0, 9.0};
        return minor;
    }

    static {
        $assertionsDisabled = !PortfolioGraphSource.class.desiredAssertionStatus();
    }
}

