/*
 * Decompiled with CFR 0.152.
 */
package org.mov.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.mov.help.HelpPage;
import org.mov.main.Module;
import org.mov.util.Locale;

public class HelpModule
extends JPanel
implements Module {
    private String backImage = "toolbarButtonGraphics/navigation/Back24.gif";
    private String forwardImage = "toolbarButtonGraphics/navigation/Forward24.gif";
    private String homeImage = "toolbarButtonGraphics/navigation/Home24.gif";
    JButton backButton = null;
    JButton forwardButton = null;
    JButton upButton = null;
    private JMenuBar menuBar;
    private JMenuItem backMenuItem;
    private JMenuItem forwardMenuItem;
    private JTree indexTree;
    private JEditorPane editorPane;
    private JDesktopPane desktop;
    private PropertyChangeSupport propertySupport;
    private HelpPage root;
    private HelpPage currentPage;
    private boolean ignoreTreeSelectionEvent = false;
    private Stack visitedPages;
    private int positionInStack;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HelpModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.setLayout(new BorderLayout());
        this.addFunctionToolBar();
        this.addMenuBar();
        this.root = HelpPage.loadIndex();
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2857142984867096);
        this.indexTree = this.createIndexTree();
        this.editorPane = this.createEditorPane();
        splitPane.setLeftComponent(new JScrollPane(this.indexTree));
        splitPane.setRightComponent(new JScrollPane(this.editorPane));
        this.add((Component)splitPane, "Center");
        this.visitedPages = new Stack();
        this.positionInStack = 0;
        this.visitedPages.push(this.root);
        this.displayPage(this.root);
    }

    private void addFunctionToolBar() {
        URL backURL = ClassLoader.getSystemResource(this.backImage);
        URL forwardURL = ClassLoader.getSystemResource(this.forwardImage);
        URL homeURL = ClassLoader.getSystemResource(this.homeImage);
        if (backURL != null && forwardURL != null && homeURL != null) {
            JToolBar toolBar = new JToolBar(0);
            this.backButton = new JButton(new ImageIcon(backURL));
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpModule.this.back();
                }
            });
            toolBar.add(this.backButton);
            this.forwardButton = new JButton(new ImageIcon(forwardURL));
            this.forwardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpModule.this.forward();
                }
            });
            toolBar.add(this.forwardButton);
            JButton homeButton = new JButton(new ImageIcon(homeURL));
            homeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpModule.this.home();
                }
            });
            toolBar.add(homeButton);
            this.add((Component)toolBar, "North");
        }
    }

    private void addMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu helpMenu = new JMenu(Locale.getString("HELP"));
        JMenuItem closeMenuItem = new JMenuItem(Locale.getString("CLOSE"));
        closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        helpMenu.add(closeMenuItem);
        JMenu goMenu = new JMenu(Locale.getString("GO"));
        this.backMenuItem = new JMenuItem(Locale.getString("BACK"));
        this.backMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpModule.this.back();
            }
        });
        goMenu.add(this.backMenuItem);
        this.forwardMenuItem = new JMenuItem(Locale.getString("FORWARD"));
        this.forwardMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpModule.this.forward();
            }
        });
        goMenu.add(this.forwardMenuItem);
        JMenuItem homeMenuItem = new JMenuItem(Locale.getString("HOME"));
        homeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpModule.this.home();
            }
        });
        goMenu.add(homeMenuItem);
        this.menuBar.add(helpMenu);
        this.menuBar.add(goMenu);
    }

    private JTree createIndexTree() {
        JTree indexTree = new JTree(this.root);
        indexTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath;
                if (!HelpModule.this.ignoreTreeSelectionEvent && (treePath = e.getPath()).getPathCount() > 0) {
                    HelpPage selectedPage = (HelpPage)treePath.getLastPathComponent();
                    HelpModule.this.jump(selectedPage);
                }
            }
        });
        return indexTree;
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.addHyperlinkListener(new HyperlinkListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String link = e.getDescription();
                    Pattern pattern = Pattern.compile("%20");
                    Matcher matcher = pattern.matcher(link);
                    link = matcher.replaceAll(" ");
                    HelpPage page = HelpModule.this.root.findPageWithLink(link);
                    if (page != null) {
                        HelpModule.this.jump(page);
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$mov$help$HelpModule == null ? (class$org$mov$help$HelpModule = HelpModule.class$("org.mov.help.HelpModule")) : class$org$mov$help$HelpModule).desiredAssertionStatus();
            }
        });
        return editorPane;
    }

    private void displayPage(HelpPage page) {
        this.editorPane.setText(page.getText());
        this.editorPane.setCaretPosition(0);
        this.currentPage = page;
        this.checkDisabledStatus();
        this.ignoreTreeSelectionEvent = true;
        this.indexTree.setSelectionPath(new TreePath(this.currentPage.getPath()));
        this.ignoreTreeSelectionEvent = false;
    }

    private void checkDisabledStatus() {
        this.backMenuItem.setEnabled(this.positionInStack > 0);
        if (this.backButton != null) {
            this.backButton.setEnabled(this.positionInStack > 0);
        }
        this.forwardMenuItem.setEnabled(this.positionInStack < this.visitedPages.size() - 1);
        if (this.forwardButton != null) {
            this.forwardButton.setEnabled(this.positionInStack < this.visitedPages.size() - 1);
        }
    }

    private void back() {
        if (!$assertionsDisabled && this.positionInStack <= 0) {
            throw new AssertionError();
        }
        HelpPage previousPage = (HelpPage)this.visitedPages.elementAt(--this.positionInStack);
        this.displayPage(previousPage);
    }

    private void forward() {
        if (!$assertionsDisabled && this.positionInStack >= this.visitedPages.size() - 1) {
            throw new AssertionError();
        }
        HelpPage nextPage = (HelpPage)this.visitedPages.elementAt(++this.positionInStack);
        this.displayPage(nextPage);
    }

    private void jump(HelpPage page) {
        while (this.positionInStack != this.visitedPages.size() - 1) {
            this.visitedPages.pop();
        }
        if (!this.visitedPages.peek().equals(page)) {
            this.visitedPages.push(page);
            ++this.positionInStack;
            this.displayPage(page);
        } else {
            this.checkDisabledStatus();
        }
    }

    private void home() {
        this.jump(this.root);
    }

    public String getTitle() {
        return Locale.getString("HELP");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public boolean encloseInScrollPane() {
        return false;
    }

    public void save() {
    }

    static {
        $assertionsDisabled = !HelpModule.class.desiredAssertionStatus();
    }
}

