/*
 * Decompiled with CFR 0.152.
 */
package org.mov.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mov.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HelpPage
extends DefaultMutableTreeNode {
    private static final String BASE_PATH = "org/mov/help/doc/";
    private static final String INDEX_DOCUMENT = "org/mov/help/doc/index.xml";
    private String name;
    private String link;
    private String text;
    private boolean isLoaded;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HelpPage(String name) {
        super(name);
        this.name = name;
        this.link = this.nameToLink(name);
        this.isLoaded = false;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public String getText() {
        this.loadText();
        return this.text;
    }

    public HelpPage findPageWithLink(String link) {
        Enumeration<TreeNode> enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            HelpPage page = (HelpPage)enumeration.nextElement();
            if (!page.getLink().equals(link)) continue;
            return page;
        }
        return null;
    }

    private String nameToLink(String name) {
        String link = name.concat(".html");
        return link;
    }

    private void loadText() {
        if (!this.isLoaded) {
            String fileName = BASE_PATH.concat(this.link);
            URL fileURL = ClassLoader.getSystemResource(fileName);
            StringBuffer stringBuffer = new StringBuffer();
            if (fileURL != null) {
                try {
                    InputStream is = fileURL.openStream();
                    InputStreamReader isr = new InputStreamReader(fileURL.openStream());
                    BufferedReader br = new BufferedReader(isr);
                    String line = br.readLine();
                    while (line != null) {
                        stringBuffer = stringBuffer.append(line);
                        stringBuffer = stringBuffer.append("\n");
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException e) {
                    this.text = Locale.getString("ERROR_LOADING_HELP_PAGE");
                    return;
                }
            } else {
                this.text = Locale.getString("HELP_PAGE_NOT_FOUND");
                return;
            }
            this.text = stringBuffer.toString();
            this.isLoaded = true;
        }
    }

    public static HelpPage loadIndex() {
        HelpPage index = null;
        Document document = HelpPage.loadIndexDocument();
        if (document != null) {
            index = new HelpPage(Locale.getString("VENICE_SHORT"));
            Element root = document.getDocumentElement();
            HelpPage.buildIndex(index, root);
        }
        if (index == null) {
            index = new HelpPage(Locale.getString("ERROR_LOADING_INDEX"));
        }
        return index;
    }

    private static void buildIndex(HelpPage index, Element root) {
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (!$assertionsDisabled && !element.getNodeName().equals("chapter")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !element.hasAttribute("name")) {
                throw new AssertionError();
            }
            HelpPage page = new HelpPage(element.getAttribute("name"));
            index.add(page);
            HelpPage.buildIndex(page, element);
        }
    }

    private static Document loadIndexDocument() {
        Document document = null;
        try {
            URL fileURL = ClassLoader.getSystemResource(INDEX_DOCUMENT);
            if (fileURL != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(fileURL.openStream());
            }
        }
        catch (IOException i) {
        }
        catch (DOMException d) {
        }
        catch (ParserConfigurationException p) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return document;
    }

    static {
        $assertionsDisabled = !HelpPage.class.desiredAssertionStatus();
    }
}

