/*
 * Decompiled with CFR 0.152.
 */
package org.mov.importer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.mov.util.Locale;

public class PreferencesXML {
    private JDesktopPane desktop = null;
    private String path = null;
    private static final String base = "org.mov";
    private static Preferences userRoot = Preferences.userRoot().node("org.mov");

    public PreferencesXML(JDesktopPane desktop) {
        this.desktop = desktop;
    }

    public void importPreferences() {
        String lastDirectory = PreferencesXML.loadImportPath();
        JFileChooser chooser = lastDirectory != null ? new JFileChooser(lastDirectory) : new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new XMLFilter());
        int action = chooser.showOpenDialog(this.desktop);
        if (action == 0) {
            lastDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            PreferencesXML.saveImportPath(lastDirectory);
            File file = chooser.getSelectedFile();
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                PreferencesXML.importPreferences(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_READING_FROM_FILE"), Locale.getString("INVALID_PREFERENCES_ERROR"), 0);
            }
            catch (Exception ex) {
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("INVALID_PREFERENCES_FORMAT_ERROR"), Locale.getString("INVALID_PREFERENCES_ERROR"), 0);
            }
        }
    }

    public void exportPreferences() {
        String lastDirectory = PreferencesXML.loadExportPath();
        JFileChooser chooser = lastDirectory != null ? new JFileChooser(lastDirectory) : new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new XMLFilter());
        int action = chooser.showSaveDialog(this.desktop);
        if (action == 0) {
            lastDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            PreferencesXML.saveExportPath(lastDirectory);
            File file = chooser.getSelectedFile();
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                PreferencesXML.exportPreferences(outputStream);
                ((OutputStream)outputStream).close();
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_WRITING_TO_FILE"), Locale.getString("INVALID_PREFERENCES_ERROR"), 0);
            }
            catch (Exception ex) {
                JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("INVALID_PREFERENCES_FORMAT_ERROR"), Locale.getString("INVALID_PREFERENCES_ERROR"), 0);
            }
        }
    }

    private static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        Preferences.importPreferences(inputStream);
    }

    private static void exportPreferences(OutputStream outputStream) throws IOException, BackingStoreException {
        userRoot.exportSubtree(outputStream);
    }

    private static String loadImportPath() {
        Preferences prefs = PreferencesXML.getUserNode("/prefs");
        String retValue = prefs.get("importPath", "");
        return retValue;
    }

    private static String loadExportPath() {
        Preferences prefs = PreferencesXML.getUserNode("/prefs");
        String retValue = prefs.get("exportPath", "");
        return retValue;
    }

    private static void saveImportPath(String importPath) {
        Preferences prefs = PreferencesXML.getUserNode("/prefs");
        prefs.put("importPath", importPath);
    }

    private static void saveExportPath(String exportPath) {
        Preferences prefs = PreferencesXML.getUserNode("/prefs");
        prefs.put("exportPath", exportPath);
    }

    private static Preferences getUserNode(String node) {
        if (node.charAt(0) == '/') {
            node = node.substring(1);
        }
        return userRoot.node(node);
    }

    public class XMLFilter
    extends FileFilter {
        public static final String xml = "xml";

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equals(xml);
            }
            return false;
        }

        public String getDescription() {
            return Locale.getString("XML_ONLY");
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(".");
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

