/*
 * Decompiled with CFR 0.152.
 */
package org.mov.macro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import org.mov.macro.StoredMacro;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.DesktopManager;
import org.mov.util.Locale;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.python.core.__builtin__;
import org.python.util.PythonInterpreter;

public class MacroManager {
    private static Hashtable err_output = new Hashtable();
    private static Hashtable out_output = new Hashtable();
    private static Hashtable compiled_macros = new Hashtable();

    public static void uncacheCompiledMacro(StoredMacro m) {
        compiled_macros.remove(m.getName());
    }

    public static void executeStartupMacros() {
        int i;
        List macros = PreferencesManager.loadStoredMacros();
        Object array_list = Array.newInstance(StoredMacro.class, macros.size());
        for (i = 0; i < macros.size(); ++i) {
            if (!((StoredMacro)macros.get(i)).isOn_startup() || ((StoredMacro)macros.get(i)).getStart_sequence() <= 0) continue;
            Array.set(array_list, ((StoredMacro)macros.get(i)).getStart_sequence(), (StoredMacro)macros.get(i));
        }
        for (i = 0; i < Array.getLength(array_list); ++i) {
            StoredMacro m = (StoredMacro)Array.get(array_list, i);
            if (m == null) continue;
            MacroManager.execute(m);
        }
    }

    public static void execute(StoredMacro m) {
        String name = m.getName();
        try {
            PySystemState.initialize();
            boolean compiled_available = true;
            PyCode tmp_compiled = (PyCode)compiled_macros.get(name);
            if (tmp_compiled == null) {
                try {
                    tmp_compiled = __builtin__.compile(m.getCode(), m.getFilename(), "exec");
                    compiled_macros.put(name, tmp_compiled);
                }
                catch (PyException e) {
                    JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("MACRO_JYTHON_COMPILE_ERROR", m.getName(), e.toString()), Locale.getString("ERROR_TITLE"), 0);
                    compiled_available = false;
                }
            }
            if (!compiled_available) {
                return;
            }
            PyCode compiled = tmp_compiled;
            PipedOutputStream err_os = new PipedOutputStream();
            PipedOutputStream out_os = new PipedOutputStream();
            class Reader
            extends Thread {
                BufferedReader br;
                String text = "";

                Reader(BufferedReader br) {
                    this.br = br;
                }

                public String getText() {
                    return this.text;
                }

                public void run() {
                    try {
                        String line = this.br.readLine();
                        while (line != null) {
                            this.text = this.text.concat(line);
                            line = this.br.readLine();
                            if (line == null) continue;
                            this.text = this.text.concat(System.getProperty("line.separator"));
                        }
                        this.br.close();
                    }
                    catch (IOException e) {
                        System.err.println("MacroManager: Reader thread failed with exception: " + e.toString());
                    }
                }
            }
            Reader err_reader = null;
            Reader out_reader = null;
            try {
                err_reader = new Reader(new BufferedReader(new InputStreamReader(new PipedInputStream(err_os))));
                err_reader.start();
                out_reader = new Reader(new BufferedReader(new InputStreamReader(new PipedInputStream(out_os))));
                out_reader.start();
            }
            catch (IOException e) {
                System.err.println("Got IOException starting up readers" + e.getMessage());
            }
            PythonInterpreter interp = new PythonInterpreter();
            try {
                interp.setErr(err_os);
                interp.setOut(out_os);
                interp.exec(compiled);
            }
            catch (PyException e) {
                JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("MACRO_JYTHON_EXCEPTION", m.getName(), e.toString()), Locale.getString("ERROR_TITLE"), 0);
            }
            try {
                err_os.close();
                out_os.close();
                err_reader.join();
                out_reader.join();
            }
            catch (InterruptedException e) {
                System.err.println("MacroManager: Main thread interrupted");
            }
            catch (IOException e) {
                System.err.println("MacroManager: IOException " + e.getMessage());
            }
            if (err_reader.getText().length() > 0) {
                JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("MACRO_OUTPUT_ERROR", m.getName(), err_reader.getText()), Locale.getString("ERROR_TITLE"), 0);
            }
            if (out_reader.getText().length() > 0) {
                JOptionPane.showInternalMessageDialog(DesktopManager.getDesktop(), Locale.getString("MACRO_INFORMATION_OUTPUT", m.getName(), out_reader.getText()), Locale.getString("MACRO_INFORMATION", m.getName()), 1);
            }
        }
        catch (NoClassDefFoundError err) {
            System.out.println("Jython ain't happenin, dude");
        }
    }
}

