/*
 * Decompiled with CFR 0.152.
 */
package org.mov.macro;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mov.main.Module;
import org.mov.prefs.PreferencesManager;
import org.mov.util.Locale;

public class MacroModule
extends JPanel
implements Module,
ActionListener {
    private JPanel list_panel = null;
    private JPanel button_panel = null;
    private JScrollPane macro_pane = null;
    private JList macro_list = null;
    private JButton new_button = null;
    private JButton edit_button = null;
    private JButton import_button = null;
    private JButton delete_button = null;
    private PropertyChangeSupport propertySupport;
    private String frameIcon = "org/mov/images/TableIcon.gif";
    private JDesktopPane desktop;

    public String getTitle() {
        return Locale.getString("MACRO_MANAGER");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.frameIcon));
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public boolean encloseInScrollPane() {
        return false;
    }

    public void save() {
    }

    public MacroModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getJPanel(), "Center");
        this.add((Component)this.getJPanel1(), "South");
    }

    private JPanel getJPanel() {
        if (this.list_panel == null) {
            this.list_panel = new JPanel();
            this.list_panel.setLayout(new BorderLayout());
            this.list_panel.add((Component)this.getMacro_pane(), "Center");
        }
        return this.list_panel;
    }

    private JPanel getJPanel1() {
        if (this.button_panel == null) {
            this.button_panel = new JPanel();
            this.button_panel.add((Component)this.getJButton(), null);
            this.button_panel.add((Component)this.getJButton2(), null);
            this.button_panel.add((Component)this.getJButton1(), null);
            this.button_panel.add((Component)this.getJButton3(), null);
        }
        return this.button_panel;
    }

    private JScrollPane getMacro_pane() {
        if (this.macro_pane == null) {
            this.macro_pane = new JScrollPane();
            this.macro_pane.setViewportView(this.getJList());
        }
        return this.macro_pane;
    }

    private JList getJList() {
        if (this.macro_list == null) {
            this.macro_list = new JList();
        }
        return this.macro_list;
    }

    private JButton getJButton() {
        if (this.new_button == null) {
            this.new_button = new JButton();
            this.new_button.setText(Locale.getString("NEW"));
            this.new_button.setMnemonic(78);
            this.new_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.new_button;
    }

    private JButton getJButton1() {
        if (this.edit_button == null) {
            this.edit_button = new JButton();
            this.edit_button.setMnemonic(69);
            this.edit_button.setText(Locale.getString("EDIT"));
        }
        return this.edit_button;
    }

    private JButton getJButton2() {
        if (this.import_button == null) {
            this.import_button = new JButton();
            this.import_button.setText(Locale.getString("IMPORT"));
            this.import_button.setMnemonic(73);
        }
        return this.import_button;
    }

    private JButton getJButton3() {
        if (this.delete_button == null) {
            this.delete_button = new JButton();
            this.delete_button.setMnemonic(68);
            this.delete_button.setText(Locale.getString("DELETE"));
        }
        return this.delete_button;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.new_button || e.getSource() == this.edit_button) return;
        if (e.getSource() == this.import_button) {
            String lastDirectory = PreferencesManager.loadDirectoryLocation("macros");
            JFileChooser chooser = lastDirectory != null ? new JFileChooser(lastDirectory) : new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            int action = chooser.showOpenDialog(this.desktop);
            if (action != 0) return;
            lastDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            PreferencesManager.saveDirectoryLocation("importer", lastDirectory);
            File file = chooser.getSelectedFile();
            if (file == null) return;
        }
        if (e.getSource() != this.delete_button) return;
    }
}

