/*
 * Decompiled with CFR 0.152.
 */
package org.mov.macro;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import org.mov.macro.MacroManager;
import org.mov.prefs.PreferencesManager;

public class StoredMacro {
    private String name = "";
    private String filename = "";
    private String code = "";
    private boolean on_startup = false;
    private int start_sequence = -1;
    private boolean in_menu = false;

    public StoredMacro() {
    }

    public StoredMacro(String name, String filename, boolean on_startup, int start_sequence, boolean in_menu) {
        this.name = name;
        this.filename = filename;
        this.on_startup = on_startup;
        this.start_sequence = start_sequence;
        this.in_menu = in_menu;
    }

    public String getName() {
        if (this.filename.length() == 0) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOn_startup() {
        return this.on_startup;
    }

    public void setOn_startup(boolean on_startup) {
        this.on_startup = on_startup;
    }

    public int getStart_sequence() {
        return this.start_sequence;
    }

    public void setStart_sequence(int start_sequence) {
        this.start_sequence = start_sequence;
    }

    public boolean isIn_menu() {
        return this.in_menu;
    }

    public void setIn_menu(boolean in_menu) {
        this.in_menu = in_menu;
    }

    public String getFilename() {
        if (this.filename.length() == 0) {
            return "";
        }
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean load() {
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            try {
                File file = new File(PreferencesManager.loadDirectoryLocation("macros") + File.separator + this.getFilename());
                URL url = file.toURL();
                InputStreamReader isr = new InputStreamReader(url.openStream());
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                String macro_text = "";
                while (line != null) {
                    macro_text = macro_text.concat(line);
                    line = br.readLine();
                    if (line == null) continue;
                    macro_text = macro_text.concat(System.getProperty("line.separator"));
                }
                this.code = macro_text;
            }
            catch (Exception e) {
                System.err.println("Exception at StoredMacro.load(): " + e.toString());
                return false;
            }
        }
        return true;
    }

    public boolean save() {
        if (this.getFilename() != null) {
            try {
                File file = new File(PreferencesManager.loadDirectoryLocation("macros") + File.separator + this.getFilename());
                URI uri = file.toURI();
                FileOutputStream fos = new FileOutputStream(new File(uri));
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                BufferedWriter bw = new BufferedWriter(osw);
                bw.write(this.getCode(), 0, this.getCode().length());
                bw.flush();
                bw.close();
                MacroManager.uncacheCompiledMacro(this);
            }
            catch (Exception e) {
                System.err.println("Exception at StoredMacro.save(): " + e.toString());
                return false;
            }
        }
        return true;
    }

    public boolean delete() {
        try {
            File file = new File(PreferencesManager.loadDirectoryLocation("macros") + File.separator + this.getFilename());
            file.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getCode() {
        if (this.code == "") {
            this.load();
        }
        if (this.code == null) {
            return "";
        }
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

