/*
 * Decompiled with CFR 0.152.
 */
package org.mov.main;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import org.mov.analyser.GAModule;
import org.mov.analyser.GAResultModule;
import org.mov.analyser.GPModule;
import org.mov.analyser.GPPageInitialPopulation;
import org.mov.analyser.GPResultModule;
import org.mov.analyser.PaperTradeModule;
import org.mov.analyser.PaperTradeResultModule;
import org.mov.chart.ChartModule;
import org.mov.chart.graph.AdvanceDeclineGraph;
import org.mov.chart.graph.Graph;
import org.mov.chart.graph.LineGraph;
import org.mov.chart.source.OHLCVIndexQuoteGraphSource;
import org.mov.chart.source.OHLCVQuoteGraphSource;
import org.mov.chart.source.PortfolioGraphSource;
import org.mov.help.HelpModule;
import org.mov.importer.PreferencesXML;
import org.mov.main.Main;
import org.mov.main.ModuleFrame;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.PortfolioModule;
import org.mov.prefs.PreferencesManager;
import org.mov.prefs.PreferencesModule;
import org.mov.quote.ExportQuoteModule;
import org.mov.quote.ImportQuoteModule;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.table.PortfolioTableModule;
import org.mov.table.QuoteModule;
import org.mov.table.WatchScreen;
import org.mov.table.WatchScreenModule;
import org.mov.ui.DesktopManager;
import org.mov.ui.GPLViewDialog;
import org.mov.ui.MainMenu;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.ui.SymbolListDialog;
import org.mov.ui.TextDialog;
import org.mov.ui.TradingDateDialog;
import org.mov.util.ExpressionQuery;
import org.mov.util.Locale;
import org.mov.util.TradingDate;

public class CommandManager {
    private static CommandManager instance;
    private DesktopManager desktopManager;
    private JDesktopPane desktop;
    private boolean isAboutDialogUp = false;
    private boolean isLicenseDialogUp = false;
    private JInternalFrame importQuoteModuleFrame = null;
    private JInternalFrame exportQuoteModuleFrame = null;
    private JInternalFrame preferencesModuleFrame = null;
    private java.util.Locale french = new java.util.Locale("FR");
    private java.util.Locale italian = new java.util.Locale("IT");
    private java.util.Locale swedish = new java.util.Locale("SV");
    private java.util.Locale simplifiedChinese = new java.util.Locale("ZH");
    static final /* synthetic */ boolean $assertionsDisabled;

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
        this.desktop = DesktopManager.getDesktop();
    }

    public void tileFramesHorizontal() {
        DesktopManager.tileFrames(0);
    }

    public void tileFramesVertical() {
        DesktopManager.tileFrames(1);
    }

    public void tileFramesCascade() {
        DesktopManager.tileFrames(2);
    }

    public void tileFramesArrange() {
        DesktopManager.tileFrames(3);
    }

    public void tableTransactions(Portfolio portfolio, QuoteBundle quoteBundle) {
        PortfolioModule porfolioModule = new PortfolioModule(this.desktop, portfolio, quoteBundle);
        this.desktopManager.newFrame(porfolioModule);
        porfolioModule.tablePortfolio();
    }

    public void tableStocks(final int type) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                String title = new String(Locale.getString("LIST_IT", QuoteRange.getDescription(type)));
                CommandManager.this.tableStocks(title, type, null, null, null);
            }
        });
        thread2.start();
    }

    public void tableStocks(final List symbols) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                TreeSet symbolsCopy;
                String description = QuoteRange.getDescription(4);
                String title = new String(Locale.getString("LIST_IT", description));
                if (symbols == null) {
                    symbolsCopy = SymbolListDialog.getSymbols(CommandManager.this.desktop, title);
                } else {
                    symbolsCopy = new TreeSet(symbols);
                    Iterator iterator = symbolsCopy.iterator();
                    while (iterator.hasNext()) {
                        Symbol symbol = (Symbol)iterator.next();
                        if (QuoteSourceManager.getSource().symbolExists(symbol)) continue;
                        JOptionPane.showInternalMessageDialog(CommandManager.this.desktop, Locale.getString("NO_QUOTES_SYMBOL", symbol.toString()), Locale.getString("INVALID_SYMBOL_LIST"), 0);
                        return;
                    }
                }
                if (symbolsCopy != null && symbolsCopy.size() > 0) {
                    CommandManager.this.tableStocks(title, 4, null, symbolsCopy, null);
                }
            }
        });
        thread2.start();
    }

    public void tableStocksByDate(final int type) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                String title = new String(Locale.getString("LIST_IT_BY_DATE", QuoteRange.getDescription(type)));
                TradingDate date = TradingDateDialog.getDate(CommandManager.this.desktop, title, Locale.getString("DATE"));
                if (date != null) {
                    CommandManager.this.tableStocks(title, type, null, null, date);
                }
            }
        });
        thread2.start();
    }

    public void tableStocksByRule(final int type) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                String title = new String(Locale.getString("LIST_IT_BY_RULE", QuoteRange.getDescription(type)));
                String rule = ExpressionQuery.getExpression(CommandManager.this.desktop, title, Locale.getString("RULE"));
                if (rule != null) {
                    CommandManager.this.tableStocks(title, type, rule, null, null);
                }
            }
        });
        thread2.start();
    }

    private void tableStocks(String title, int type, String rule, SortedSet symbols, TradingDate date) {
        Thread thread2 = Thread.currentThread();
        ScriptQuoteBundle quoteBundle = null;
        QuoteRange quoteRange = null;
        QuoteModule table = null;
        ProgressDialog progressDialog = ProgressDialogManager.getProgressDialog();
        progressDialog.show(title);
        boolean singleDate = false;
        if (!thread2.isInterrupted()) {
            if (type == 4) {
                quoteRange = new QuoteRange(new ArrayList(symbols));
                singleDate = false;
            } else {
                if (date == null) {
                    date = QuoteSourceManager.getSource().getLastDate();
                }
                if (!thread2.isInterrupted()) {
                    if (!$assertionsDisabled && date == null) {
                        throw new AssertionError();
                    }
                    quoteRange = new QuoteRange(type, date.previous(1), date);
                }
                singleDate = true;
            }
        }
        if (!thread2.isInterrupted()) {
            quoteBundle = new ScriptQuoteBundle(quoteRange);
        }
        if (!thread2.isInterrupted()) {
            table = new QuoteModule(quoteBundle, rule, singleDate);
            this.desktopManager.newFrame(table);
        }
        ProgressDialogManager.closeProgressDialog(progressDialog);
    }

    public void openPortfolio(String portfolioName) {
        Portfolio portfolio = PreferencesManager.loadPortfolio(portfolioName);
        this.openPortfolio(portfolio);
    }

    public void openPortfolio(final Portfolio portfolio) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                Thread thread2 = Thread.currentThread();
                ProgressDialog progress = ProgressDialogManager.getProgressDialog();
                progress.show(Locale.getString("OPEN_PORTFOLIO", portfolio.getName()));
                ScriptQuoteBundle quoteBundle = null;
                TradingDate lastDate = QuoteSourceManager.getSource().getLastDate();
                if (lastDate != null) {
                    if (!thread2.isInterrupted()) {
                        QuoteRange quoteRange = new QuoteRange(2, lastDate.previous(1), lastDate);
                        quoteBundle = new ScriptQuoteBundle(quoteRange);
                    }
                    if (!thread2.isInterrupted()) {
                        CommandManager.this.openPortfolio(portfolio, quoteBundle);
                    }
                }
                ProgressDialogManager.closeProgressDialog(progress);
            }
        });
        thread2.start();
    }

    public void openPortfolio(Portfolio portfolio, QuoteBundle quoteBundle) {
        this.desktopManager.newFrame(new PortfolioModule(this.desktop, portfolio, quoteBundle));
    }

    public void paperTrade() {
        PaperTradeModule module = new PaperTradeModule(this.desktop);
        this.desktopManager.newFrame(module, true, true, true);
    }

    public void gp() {
        GPModule module = new GPModule(this.desktop);
        this.desktopManager.newFrame(module, true, true, true);
    }

    public void ga() {
        GAModule module = new GAModule(this.desktop);
        this.desktopManager.newFrame(module, true, true, true);
    }

    public ModuleFrame newPaperTradeResultTable() {
        PaperTradeResultModule results = new PaperTradeResultModule();
        return this.desktopManager.newFrame(results);
    }

    public ModuleFrame newGPResultTable(GPPageInitialPopulation GPPageInitialPopulation2) {
        GPResultModule results = new GPResultModule(GPPageInitialPopulation2);
        return this.desktopManager.newFrame(results);
    }

    public ModuleFrame newGAResultTable() {
        GAResultModule results = new GAResultModule();
        return this.desktopManager.newFrame(results);
    }

    public void newWatchScreen() {
        TextDialog dialog = new TextDialog(this.desktop, Locale.getString("ENTER_WATCH_SCREEN_NAME"), Locale.getString("NEW_WATCH_SCREEN"));
        String watchScreenName = dialog.showDialog();
        if (watchScreenName != null && watchScreenName.length() > 0) {
            WatchScreen watchScreen = new WatchScreen(watchScreenName);
            PreferencesManager.saveWatchScreen(watchScreen);
            MainMenu.getInstance().updateWatchScreenMenu();
            this.openWatchScreen(watchScreen);
        }
    }

    public void openWatchScreen(String watchScreenName) {
        WatchScreen watchScreen = PreferencesManager.loadWatchScreen(watchScreenName);
        this.openWatchScreen(watchScreen);
    }

    public void openWatchScreen(final WatchScreen watchScreen) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                Thread thread2 = Thread.currentThread();
                ProgressDialog progress = ProgressDialogManager.getProgressDialog();
                progress.show(Locale.getString("OPEN_WATCH_SCREEN", watchScreen.getName()));
                ScriptQuoteBundle quoteBundle = null;
                TradingDate lastDate = QuoteSourceManager.getSource().getLastDate();
                if (lastDate != null) {
                    if (!thread2.isInterrupted()) {
                        QuoteRange quoteRange = new QuoteRange(2, lastDate.previous(1), lastDate);
                        quoteBundle = new ScriptQuoteBundle(quoteRange);
                    }
                    if (!thread2.isInterrupted()) {
                        CommandManager.this.desktopManager.newFrame(new WatchScreenModule(watchScreen, quoteBundle));
                    }
                }
                ProgressDialogManager.closeProgressDialog(progress);
            }
        });
        thread2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPreferences() {
        CommandManager commandManager = this;
        synchronized (commandManager) {
            if (!this.wakeIfPresent(this.preferencesModuleFrame)) {
                PreferencesModule preferencesModule = new PreferencesModule(this.desktop);
                this.preferencesModuleFrame = this.desktopManager.newFrame(preferencesModule, true, false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPreferences(int page) {
        CommandManager commandManager = this;
        synchronized (commandManager) {
            if (!this.wakeIfPresent(this.preferencesModuleFrame)) {
                PreferencesModule preferencesModule = new PreferencesModule(this.desktop, page);
                this.preferencesModuleFrame = this.desktopManager.newFrame(preferencesModule, true, false, true);
            }
        }
    }

    public void newPortfolio() {
        TextDialog dialog = new TextDialog(this.desktop, Locale.getString("ENTER_PORTFOLIO_NAME"), Locale.getString("NEW_PORTFOLIO"));
        String portfolioName = dialog.showDialog();
        if (portfolioName != null && portfolioName.length() > 0) {
            Portfolio portfolio = new Portfolio(portfolioName);
            PreferencesManager.savePortfolio(portfolio);
            MainMenu.getInstance().updatePortfolioMenu();
            this.openPortfolio(portfolioName);
        }
    }

    public void graphPortfolio(Portfolio portfolio) {
        this.graphPortfolio(portfolio, null, null, null);
    }

    public void graphPortfolio(Portfolio portfolio, QuoteBundle quoteBundle) {
        this.graphPortfolio(portfolio, quoteBundle, null, null);
    }

    public void graphPortfolio(Portfolio portfolio, QuoteBundle quoteBundle, TradingDate startDate, TradingDate endDate) {
        ChartModule chart = new ChartModule(this.desktop);
        Thread thread2 = Thread.currentThread();
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.show(Locale.getString("GRAPH_PORTFOLIO", portfolio.getName()));
        List symbolsTraded = portfolio.getSymbolsTraded();
        PortfolioGraphSource portfolioGraphSource = null;
        LineGraph graph = null;
        if (symbolsTraded.size() > 0 && quoteBundle == null) {
            if (startDate == null) {
                startDate = portfolio.getStartDate();
            }
            if (endDate == null && (endDate = QuoteSourceManager.getSource().getLastDate()).before(startDate)) {
                endDate = startDate;
            }
            quoteBundle = new ScriptQuoteBundle(new QuoteRange(symbolsTraded, startDate, endDate));
        }
        if (symbolsTraded.size() == 0) {
            DesktopManager.showErrorMessage(Locale.getString("NOTHING_TO_GRAPH"));
        } else if (!thread2.isInterrupted()) {
            portfolioGraphSource = new PortfolioGraphSource(portfolio, quoteBundle, 0);
            graph = new LineGraph(portfolioGraphSource, Locale.getString("MARKET_VALUE"), true);
            chart.add((Graph)graph, portfolio, quoteBundle, 0);
            chart.redraw();
            this.desktopManager.newFrame(chart);
        }
        ProgressDialogManager.closeProgressDialog(progress);
    }

    public void tablePortfolio(Portfolio portfolio) {
        this.tablePortfolio(portfolio, null, null, null);
    }

    public void tablePortfolio(Portfolio portfolio, QuoteBundle quoteBundle) {
        this.tablePortfolio(portfolio, quoteBundle, null, null);
    }

    public void tablePortfolio(Portfolio portfolio, QuoteBundle quoteBundle, TradingDate startDate, TradingDate endDate) {
        Thread thread2 = Thread.currentThread();
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        progress.show(Locale.getString("TABLE_PORTFOLIO", portfolio.getName()));
        List symbolsTraded = portfolio.getSymbolsTraded();
        if (symbolsTraded.size() > 0 && quoteBundle == null) {
            if (startDate == null) {
                startDate = portfolio.getStartDate();
            }
            if (endDate == null && (endDate = QuoteSourceManager.getSource().getLastDate()).before(startDate)) {
                endDate = startDate;
            }
            quoteBundle = new ScriptQuoteBundle(new QuoteRange(symbolsTraded, startDate, endDate));
        }
        if (!thread2.isInterrupted()) {
            PortfolioTableModule table = new PortfolioTableModule(portfolio, quoteBundle);
            this.desktopManager.newFrame(table);
        }
        ProgressDialogManager.closeProgressDialog(progress);
    }

    public void graphAdvanceDecline() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                Thread thread2 = Thread.currentThread();
                AdvanceDeclineGraph graph = new AdvanceDeclineGraph();
                if (!thread2.isInterrupted()) {
                    ChartModule chart = new ChartModule(CommandManager.this.desktop);
                    chart.addMarketIndicator(graph);
                    chart.redraw();
                    CommandManager.this.desktopManager.newFrame(chart);
                }
            }
        });
        thread2.start();
    }

    public void graphStockBySymbol(final List symbols) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                SortedSet symbolsCopy;
                if (symbols == null) {
                    symbolsCopy = SymbolListDialog.getSymbols(CommandManager.this.desktop, Locale.getString("GRAPH_BY_SYMBOLS"));
                } else {
                    symbolsCopy = new TreeSet(symbols);
                    Iterator iterator = symbolsCopy.iterator();
                    while (iterator.hasNext()) {
                        Symbol symbol = (Symbol)iterator.next();
                        if (QuoteSourceManager.getSource().symbolExists(symbol)) continue;
                        JOptionPane.showInternalMessageDialog(CommandManager.this.desktop, Locale.getString("NO_QUOTES_SYMBOL", symbol.toString()), Locale.getString("INVALID_SYMBOL_LIST"), 0);
                        return;
                    }
                }
                CommandManager.this.graphStock(symbolsCopy);
            }
        });
        thread2.start();
    }

    public void graphIndexBySymbol(final List symbols) {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                SortedSet symbolsCopy;
                if (symbols == null) {
                    symbolsCopy = SymbolListDialog.getSymbols(CommandManager.this.desktop, Locale.getString("GRAPH_BY_SYMBOLS"));
                } else {
                    symbolsCopy = new TreeSet(symbols);
                    Iterator iterator = symbolsCopy.iterator();
                    while (iterator.hasNext()) {
                        Symbol symbol = (Symbol)iterator.next();
                        if (QuoteSourceManager.getSource().symbolExists(symbol)) continue;
                        JOptionPane.showInternalMessageDialog(CommandManager.this.desktop, Locale.getString("NO_QUOTES_SYMBOL", symbol.toString()), Locale.getString("INVALID_SYMBOL_LIST"), 0);
                        return;
                    }
                }
                CommandManager.this.graphIndex(symbolsCopy);
            }
        });
        thread2.start();
    }

    private void graphStock(SortedSet symbols) {
        if (symbols != null) {
            ChartModule chart = new ChartModule(this.desktop);
            Thread thread2 = Thread.currentThread();
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            Iterator iterator = symbols.iterator();
            ScriptQuoteBundle quoteBundle = null;
            OHLCVQuoteGraphSource dayClose = null;
            LineGraph graph = null;
            String title = symbols.toString();
            title = title.substring(1, title.length() - 1);
            boolean progressValue = false;
            if (symbols.size() > 1) {
                progress.setIndeterminate(false);
                progress.setMaximum(symbols.size());
                progress.setMaster(true);
            } else {
                progress.setIndeterminate(true);
            }
            progress.show(Locale.getString("GRAPH_SYMBOLS", title));
            while (iterator.hasNext() && !thread2.isInterrupted()) {
                Symbol symbol = (Symbol)iterator.next();
                quoteBundle = new ScriptQuoteBundle(new QuoteRange(symbol));
                if (thread2.isInterrupted()) break;
                dayClose = new OHLCVQuoteGraphSource(quoteBundle, 0);
                graph = new LineGraph(dayClose, Locale.getString("DAY_CLOSE"), true);
                chart.add((Graph)graph, symbol, (QuoteBundle)quoteBundle, 0);
                chart.redraw();
                if (symbols.size() <= 1) continue;
                progress.increment();
            }
            if (!thread2.isInterrupted()) {
                this.desktopManager.newFrame(chart);
            }
            ProgressDialogManager.closeProgressDialog(progress);
        }
    }

    private void graphIndex(SortedSet symbols) {
        if (symbols != null) {
            ChartModule chart = new ChartModule(this.desktop, true);
            Thread thread2 = Thread.currentThread();
            ProgressDialog progress = ProgressDialogManager.getProgressDialog();
            Iterator iterator = symbols.iterator();
            ScriptQuoteBundle quoteBundle = null;
            OHLCVIndexQuoteGraphSource dayClose = null;
            LineGraph graph = null;
            String title = symbols.toString();
            title = title.substring(1, title.length() - 1);
            boolean progressValue = false;
            if (symbols.size() > 1) {
                progress.setIndeterminate(false);
                progress.setMaximum(symbols.size());
                progress.setMaster(true);
            } else {
                progress.setIndeterminate(true);
            }
            progress.show(Locale.getString("GRAPH_SYMBOLS", title));
            quoteBundle = new ScriptQuoteBundle(new QuoteRange(symbols));
            dayClose = new OHLCVIndexQuoteGraphSource(quoteBundle, 0);
            graph = new LineGraph(dayClose, Locale.getString("GRAPH_INDEX"), true);
            Symbol symbol = (Symbol)iterator.next();
            chart.add((Graph)graph, symbol, (QuoteBundle)quoteBundle, 0);
            chart.redraw();
            if (symbols.size() > 1) {
                progress.increment();
            }
            if (!thread2.isInterrupted()) {
                this.desktopManager.newFrame(chart);
            }
            ProgressDialogManager.closeProgressDialog(progress);
        }
    }

    public void openAboutDialog() {
        if (!this.isAboutDialogUp) {
            this.isAboutDialogUp = true;
            String aboutMessage = Locale.getString("VENICE_LONG") + ", " + Main.LONG_VERSION + " / " + Main.RELEASE_DATE + "\n" + Locale.getString("COPYRIGHT", "2003-5") + ", " + "Andrew Leppard\n\n" + "Andrew Leppard (aleppard@picknow.com.au)\n\n" + Locale.getString("ADDITIONAL_CODE") + "\n" + "Daniel Makovec, Quentin Bossard, Peter Fradley, Mark Hummel,\n" + "Bryan Lin, Alberto Nacher & Matthias St\u00f6ckel.\n\n" + Locale.getString("TRANSLATORS") + "\n" + "Quentin Bossard (" + this.french.getDisplayName() + "), " + "Bryan Lin (" + this.simplifiedChinese.getDisplayName() + ")\n" + "Alberto Nacher (" + this.italian.getDisplayName() + "), " + "Pontus Str\u00f6mdahl (" + this.swedish.getDisplayName() + ")";
            String aboutVenice = Locale.getString("ABOUT_VENICE", Locale.getString("VENICE_SHORT"));
            JOptionPane.showInternalMessageDialog(this.desktop, aboutMessage, aboutVenice, -1);
            this.isAboutDialogUp = false;
        }
    }

    public void openLicenseDialog() {
        if (!this.isLicenseDialogUp) {
            this.isLicenseDialogUp = true;
            GPLViewDialog.showGPLViewDialog();
            this.isLicenseDialogUp = false;
        }
    }

    public void openHelp() {
        HelpModule helpModule = new HelpModule(this.desktop);
        this.desktopManager.newFrame(helpModule, false, false, true);
    }

    public void importPreferences() {
        PreferencesXML prefs = new PreferencesXML(this.desktop);
        prefs.importPreferences();
    }

    public void exportPreferences() {
        PreferencesXML prefs = new PreferencesXML(this.desktop);
        prefs.exportPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importQuotes() {
        CommandManager commandManager = this;
        synchronized (commandManager) {
            if (!this.wakeIfPresent(this.importQuoteModuleFrame)) {
                ImportQuoteModule importQuoteModule = new ImportQuoteModule(this.desktop);
                this.importQuoteModuleFrame = this.desktopManager.newFrame(importQuoteModule, true, true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportQuotes() {
        CommandManager commandManager = this;
        synchronized (commandManager) {
            if (!this.wakeIfPresent(this.exportQuoteModuleFrame)) {
                ExportQuoteModule exportQuoteModule = new ExportQuoteModule(this.desktop);
                this.exportQuoteModuleFrame = this.desktopManager.newFrame(exportQuoteModule, true, true, false);
            }
        }
    }

    private boolean wakeIfPresent(JInternalFrame frame) {
        if (frame != null && !frame.isClosed()) {
            block3: {
                frame.toFront();
                try {
                    frame.setIcon(false);
                    frame.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !CommandManager.class.desiredAssertionStatus();
        instance = null;
    }
}

