/*
 * Decompiled with CFR 0.152.
 */
package org.mov.main;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.mov.macro.MacroManager;
import org.mov.main.CommandManager;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.QuoteSourceManager;
import org.mov.ui.DesktopManager;
import org.mov.ui.GPLViewDialog;
import org.mov.ui.MainMenu;
import org.mov.util.Locale;

public class Main
extends JFrame {
    private JDesktopPane desktop;
    private DesktopManager desktopManager;
    private PreferencesManager.DisplayPreferences displayPreferences;
    private static Main venice;
    public static String SHORT_VERSION;
    public static String LONG_VERSION;
    public static String RELEASE_DATE;

    public static JFrame getApplicationFrame() {
        return venice;
    }

    private Main() {
        Locale.setLocale();
        String title = Locale.getString("VENICE_LONG") + ", " + LONG_VERSION + " / " + RELEASE_DATE;
        System.out.println(title);
        for (int i = 0; i < title.length(); ++i) {
            System.out.print("-");
        }
        System.out.println("");
        System.out.println(Locale.getString("COPYRIGHT", "2003-5") + ", " + "Andrew Leppard (aleppard@picknowl.com.au)");
        System.out.println(Locale.getString("SEE_LICENSE"));
        this.displayPreferences = PreferencesManager.loadDisplaySettings();
        this.setSize(this.displayPreferences.width, this.displayPreferences.height);
        this.setLocation(this.displayPreferences.x, this.displayPreferences.y);
        this.setTitle(Locale.getString("VENICE_SHORT") + " " + SHORT_VERSION);
        this.desktop = new JDesktopPane();
        this.desktopManager = new DesktopManager(this.desktop);
        this.desktop.setDesktopManager(this.desktopManager);
        this.desktop.setBackground(new Color(238, 241, 238));
        CommandManager.getInstance().setDesktopManager(this.desktopManager);
        MainMenu.getInstance(this, this.desktopManager);
        this.setContentPane(this.desktop);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Main.this.saveSettingsAndExit();
            }

            public void windowClosed(WindowEvent e) {
                Main.this.saveSettingsAndExit();
            }
        });
    }

    private void saveSettingsAndExit() {
        this.displayPreferences.x = this.getX();
        this.displayPreferences.y = this.getY();
        this.displayPreferences.width = this.getWidth();
        this.displayPreferences.height = this.getHeight();
        PreferencesManager.saveDisplaySettings(this.displayPreferences);
        this.desktopManager.save();
        QuoteSourceManager.shutdown();
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        venice = new Main();
        if (PreferencesManager.requireGPLAcceptance()) {
            MainMenu.getInstance().disableMenus();
        }
        venice.setVisible(true);
        if (PreferencesManager.requireGPLAcceptance()) {
            if (!GPLViewDialog.showGPLAcceptanceDialog()) {
                venice.dispose();
                System.exit(0);
            } else {
                PreferencesManager.setGPLAcceptance();
                MainMenu.getInstance().enableMenus();
            }
        }
        try {
            MacroManager.executeStartupMacros();
        }
        catch (NoClassDefFoundError err) {
            System.out.println(Locale.getString("NO_JYTHON_ERROR"));
        }
    }

    static {
        SHORT_VERSION = "0.51a";
        LONG_VERSION = "0.51 alpha";
        RELEASE_DATE = "2/" + Locale.getString("APR") + "/2005";
    }
}

