/*
 * Decompiled with CFR 0.152.
 */
package org.mov.main;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.mov.main.Module;
import org.mov.ui.DesktopManager;

public class ModuleFrame
extends JInternalFrame
implements PropertyChangeListener,
InternalFrameListener {
    public static final String WINDOW_CLOSE_PROPERTY = "window close";
    public static final String TITLEBAR_CHANGED_PROPERTY = "titlebar changed";
    private static final int DEFAULT_LAYER = 2;
    private Module module;
    private DesktopManager desktopManager;
    private static int DEFAULT_FRAME_WIDTH = 535;
    private static int DEFAULT_FRAME_HEIGHT = 475;

    public ModuleFrame(DesktopManager desktopManager, Module module, boolean centre, boolean honourSize, boolean resizable) {
        super(module.getTitle(), resizable, true, resizable, true);
        this.module = module;
        this.desktopManager = desktopManager;
        JDesktopPane desktop = DesktopManager.getDesktop();
        if (module.encloseInScrollPane()) {
            this.getContentPane().add(new JScrollPane(module.getComponent()));
        } else {
            this.getContentPane().add(module.getComponent());
        }
        ModuleFrame.setSizeAndLocation(this, desktop, centre, honourSize);
        if (module.getJMenuBar() != null) {
            this.setJMenuBar(module.getJMenuBar());
        }
        module.addModuleChangeListener(this);
        super.setFrameIcon(module.getFrameIcon());
        this.addInternalFrameListener(this);
        this.show();
    }

    public static void setSizeAndLocation(JInternalFrame frame, JDesktopPane desktop, boolean centre, boolean honourSize) {
        int y;
        int x;
        int height;
        int width;
        Dimension preferred = frame.getPreferredSize();
        if (honourSize) {
            width = preferred.width;
            height = preferred.height;
        } else {
            width = DEFAULT_FRAME_WIDTH;
            height = DEFAULT_FRAME_HEIGHT;
        }
        if (centre) {
            x = (desktop.getWidth() - width) / 2;
            y = (desktop.getHeight() - height) / 2;
        } else {
            x = 0;
            y = 0;
        }
        if (x > desktop.getWidth()) {
            x = desktop.getWidth() - width;
        }
        if (y > desktop.getHeight()) {
            y = desktop.getWidth() - height;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (width > x + desktop.getWidth()) {
            width = desktop.getWidth() - x;
        }
        if (height > y + desktop.getHeight()) {
            height = desktop.getHeight() - y;
        }
        frame.setBounds(x, y, width, height);
    }

    public Module getModule() {
        return this.module;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (property.equals(WINDOW_CLOSE_PROPERTY)) {
            this.dispose();
        } else if (property.equals(TITLEBAR_CHANGED_PROPERTY)) {
            this.setTitle(this.module.getTitle());
            this.desktopManager.fireModuleRenamed(this.module);
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        this.module.save();
        this.desktopManager.fireModuleRemoved(this.module);
    }

    public void internalFrameActivated(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }
}

