/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser;

import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Token;
import org.mov.parser.Variables;
import org.mov.parser.expression.AbsExpression;
import org.mov.parser.expression.AbstractExpression;
import org.mov.parser.expression.AddExpression;
import org.mov.parser.expression.AndExpression;
import org.mov.parser.expression.AvgExpression;
import org.mov.parser.expression.BBLExpression;
import org.mov.parser.expression.BBUExpression;
import org.mov.parser.expression.CorrExpression;
import org.mov.parser.expression.DayExpression;
import org.mov.parser.expression.DayOfWeekExpression;
import org.mov.parser.expression.DayOfYearExpression;
import org.mov.parser.expression.DivideExpression;
import org.mov.parser.expression.EMAExpression;
import org.mov.parser.expression.EqualThanExpression;
import org.mov.parser.expression.ForExpression;
import org.mov.parser.expression.GreaterThanEqualExpression;
import org.mov.parser.expression.GreaterThanExpression;
import org.mov.parser.expression.IfExpression;
import org.mov.parser.expression.LagExpression;
import org.mov.parser.expression.LessThanEqualExpression;
import org.mov.parser.expression.LessThanExpression;
import org.mov.parser.expression.MACDExpression;
import org.mov.parser.expression.MaxExpression;
import org.mov.parser.expression.MinExpression;
import org.mov.parser.expression.MomentumExpression;
import org.mov.parser.expression.MonthExpression;
import org.mov.parser.expression.MultiplyExpression;
import org.mov.parser.expression.NotEqualExpression;
import org.mov.parser.expression.NotExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.parser.expression.OBVExpression;
import org.mov.parser.expression.OrExpression;
import org.mov.parser.expression.PercentExpression;
import org.mov.parser.expression.QuoteExpression;
import org.mov.parser.expression.RSIExpression;
import org.mov.parser.expression.SDExpression;
import org.mov.parser.expression.SqrtExpression;
import org.mov.parser.expression.StringExpression;
import org.mov.parser.expression.SubtractExpression;
import org.mov.parser.expression.SumExpression;
import org.mov.parser.expression.WhileExpression;
import org.mov.parser.expression.YearExpression;

public class ExpressionFactory {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ExpressionFactory() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static Expression newExpression(Token token) {
        return ExpressionFactory.newExpression(token, null, null, null, null);
    }

    public static Expression newExpression(Token token, Expression arg1) {
        return ExpressionFactory.newExpression(token, arg1, null, null, null);
    }

    public static Expression newExpression(Token token, Expression arg1, Expression arg2) {
        return ExpressionFactory.newExpression(token, arg1, arg2, null, null);
    }

    public static Expression newExpression(Token token, Expression arg1, Expression arg2, Expression arg3) {
        return ExpressionFactory.newExpression(token, arg1, arg2, arg3, null);
    }

    public static Expression newExpression(Token token, Expression arg1, Expression arg2, Expression arg3, Expression arg4) {
        AbstractExpression expression = null;
        switch (token.getType()) {
            case 12: {
                expression = new AndExpression(arg1, arg2);
                break;
            }
            case 11: {
                expression = new OrExpression(arg1, arg2);
                break;
            }
            case 6: {
                expression = new EqualThanExpression(arg1, arg2);
                break;
            }
            case 2: {
                expression = new LessThanEqualExpression(arg1, arg2);
                break;
            }
            case 4: {
                expression = new LessThanExpression(arg1, arg2);
                break;
            }
            case 5: {
                expression = new GreaterThanExpression(arg1, arg2);
                break;
            }
            case 3: {
                expression = new GreaterThanEqualExpression(arg1, arg2);
                break;
            }
            case 7: {
                expression = new AddExpression(arg1, arg2);
                break;
            }
            case 8: {
                expression = new SubtractExpression(arg1, arg2);
                break;
            }
            case 9: {
                expression = new MultiplyExpression(arg1, arg2);
                break;
            }
            case 10: {
                expression = new DivideExpression(arg1, arg2);
                break;
            }
            case 19: {
                expression = new QuoteExpression(1);
                break;
            }
            case 20: {
                expression = new QuoteExpression(0);
                break;
            }
            case 21: {
                expression = new QuoteExpression(2);
                break;
            }
            case 22: {
                expression = new QuoteExpression(3);
                break;
            }
            case 23: {
                expression = new QuoteExpression(4);
                break;
            }
            case 15: {
                expression = new LagExpression(arg1, arg2);
                break;
            }
            case 16: {
                expression = new MinExpression(arg1, arg2, arg3);
                break;
            }
            case 17: {
                expression = new MaxExpression(arg1, arg2, arg3);
                break;
            }
            case 18: {
                expression = new AvgExpression(arg1, arg2, arg3);
                break;
            }
            case 31: {
                expression = new RSIExpression(arg1, arg2);
                break;
            }
            case 13: {
                expression = new NotExpression(arg1);
                break;
            }
            case 24: {
                expression = new IfExpression(arg1, arg2, arg3);
                break;
            }
            case 29: {
                expression = new PercentExpression(arg1, arg2);
                break;
            }
            case 30: {
                expression = new NotEqualExpression(arg1, arg2);
                break;
            }
            case 32: {
                expression = new NumberExpression(1.0, 0);
                break;
            }
            case 33: {
                expression = new NumberExpression(0.0, 0);
                break;
            }
            case 100: {
                expression = new NumberExpression(token.getValue(), token.getValueType());
                break;
            }
            case 102: {
                expression = new StringExpression(token.getStringValue());
                break;
            }
            case 34: {
                expression = new DayOfWeekExpression();
                break;
            }
            case 35: {
                expression = new DayOfYearExpression();
                break;
            }
            case 36: {
                expression = new DayExpression();
                break;
            }
            case 37: {
                expression = new MonthExpression();
                break;
            }
            case 38: {
                expression = new YearExpression();
                break;
            }
            case 39: {
                expression = new SumExpression(arg1, arg2, arg3);
                break;
            }
            case 40: {
                expression = new SqrtExpression(arg1);
                break;
            }
            case 41: {
                expression = new AbsExpression(arg1);
                break;
            }
            case 48: {
                expression = new ForExpression(arg1, arg2, arg3, arg4);
                break;
            }
            case 49: {
                expression = new WhileExpression(arg1, arg2);
                break;
            }
            case 50: {
                expression = new CorrExpression(arg1, arg2, arg3, arg4);
                break;
            }
            case 51: {
                expression = new EMAExpression(arg1, arg2, arg3, arg4);
                break;
            }
            case 52: {
                expression = new BBLExpression(arg1, arg2, arg3);
                break;
            }
            case 53: {
                expression = new BBUExpression(arg1, arg2, arg3);
                break;
            }
            case 54: {
                expression = new MACDExpression(arg1, arg2);
                break;
            }
            case 55: {
                expression = new MomentumExpression(arg1, arg2, arg3);
                break;
            }
            case 56: {
                expression = new OBVExpression(arg1, arg2, arg3);
                break;
            }
            case 57: {
                expression = new SDExpression(arg1, arg2, arg3);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return expression;
    }

    public static Expression newExpression(String inputExpressionString) {
        Expression expression = null;
        Variables variables = new Variables();
        variables.add("held", 2, true);
        variables.add("order", 2, true);
        if (inputExpressionString.length() == 0) {
            expression = null;
        } else {
            try {
                expression = Parser.parse(variables, inputExpressionString);
            }
            catch (ExpressionException e) {
                expression = null;
            }
        }
        return expression;
    }

    static {
        $assertionsDisabled = !ExpressionFactory.class.desiredAssertionStatus();
    }
}

