/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser;

import java.util.ArrayList;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.ExpressionFactory;
import org.mov.parser.ParserException;
import org.mov.parser.Token;
import org.mov.parser.TokenStack;
import org.mov.parser.Variable;
import org.mov.parser.Variables;
import org.mov.parser.expression.ClauseExpression;
import org.mov.parser.expression.DefineVariableExpression;
import org.mov.parser.expression.GetVariableExpression;
import org.mov.parser.expression.LagExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.parser.expression.SetVariableExpression;
import org.mov.util.Locale;

public class Parser {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Parser() {
    }

    public static Expression parse(Variables variables, String string) throws ExpressionException {
        TokenStack tokens = Parser.lexicalAnalysis(variables, string);
        Expression expression = Parser.parseRootExpression(variables, tokens);
        if (tokens.size() > 0) {
            throw new ParserException(Locale.getString("EXTRANEOUS_TEXT_ERROR"));
        }
        expression.checkType();
        return expression;
    }

    public static Expression parse(String string) throws ExpressionException {
        return Parser.parse(new Variables(), string);
    }

    private static TokenStack lexicalAnalysis(Variables variables, String string) throws ParserException {
        TokenStack tokens = new TokenStack();
        while (string.length() > 0) {
            while (string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
                string = string.substring(1);
            }
            if (string.length() <= 0) continue;
            Token token = new Token();
            string = Token.stringToToken(variables, token, string);
            tokens.add(token);
        }
        return tokens;
    }

    private static Expression parseRootExpression(Variables variables, TokenStack tokens) throws ParserException {
        ArrayList<Expression> subExpressions = new ArrayList<Expression>();
        while (tokens.size() > 0) {
            subExpressions.add(Parser.parseSubExpression(variables, tokens));
        }
        if (subExpressions.size() == 0) {
            throw new ParserException(Locale.getString("EMPTY_EQUATION_ERROR"));
        }
        if (subExpressions.size() == 1) {
            return (Expression)subExpressions.get(0);
        }
        return new ClauseExpression(subExpressions);
    }

    private static Expression parseExpression(Variables variables, TokenStack tokens) throws ParserException {
        if (tokens.match(25)) {
            ArrayList<Expression> subExpressions = new ArrayList<Expression>();
            boolean inClause = true;
            tokens.pop();
            while (inClause) {
                subExpressions.add(Parser.parseSubExpression(variables, tokens));
                if (tokens.size() == 0) {
                    throw new ParserException(Locale.getString("MISSING_RIGHT_BRACE_ERROR"));
                }
                if (!tokens.match(26)) continue;
                tokens.pop();
                inClause = false;
            }
            return new ClauseExpression(subExpressions);
        }
        return Parser.parseSubExpression(variables, tokens);
    }

    private static Expression parseSubExpression(Variables variables, TokenStack tokens) throws ParserException {
        Expression left = Parser.parseBooleanExpression(variables, tokens);
        if (tokens.match(12) || tokens.match(11)) {
            Token operation = tokens.pop();
            Expression right = Parser.parseBooleanExpression(variables, tokens);
            return ExpressionFactory.newExpression(operation, left, right);
        }
        return left;
    }

    private static Expression parseBooleanExpression(Variables variables, TokenStack tokens) throws ParserException {
        Expression left = Parser.parseAddExpression(variables, tokens);
        if (tokens.match(6) || tokens.match(30) || tokens.match(2) || tokens.match(4) || tokens.match(5) || tokens.match(3)) {
            Token operation = tokens.pop();
            Expression right = Parser.parseAddExpression(variables, tokens);
            return ExpressionFactory.newExpression(operation, left, right);
        }
        return left;
    }

    private static Expression parseAddExpression(Variables variables, TokenStack tokens) throws ParserException {
        Expression left = Parser.parseMultiplyExpression(variables, tokens);
        if (tokens.match(7) || tokens.match(8)) {
            Token operation = tokens.pop();
            Expression right = Parser.parseMultiplyExpression(variables, tokens);
            return ExpressionFactory.newExpression(operation, left, right);
        }
        return left;
    }

    private static Expression parseMultiplyExpression(Variables variables, TokenStack tokens) throws ParserException {
        Expression left = Parser.parseFactor(variables, tokens);
        if (tokens.match(9) || tokens.match(10)) {
            Token operation = tokens.pop();
            Expression right = Parser.parseFactor(variables, tokens);
            return ExpressionFactory.newExpression(operation, left, right);
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    private static Expression parseFactor(Variables variables, TokenStack tokens) throws ParserException {
        void var2_2;
        Expression expression;
        if (tokens.match(100) || tokens.match(32) || tokens.match(33) || tokens.match(8)) {
            expression = Parser.parseNumber(variables, tokens);
        } else if (tokens.match(102)) {
            expression = Parser.parseString(variables, tokens);
        } else if (tokens.match(15) || tokens.match(16) || tokens.match(17) || tokens.match(18) || tokens.match(57) || tokens.match(39) || tokens.match(31) || tokens.match(13) || tokens.match(29) || tokens.match(34) || tokens.match(35) || tokens.match(36) || tokens.match(37) || tokens.match(38) || tokens.match(40) || tokens.match(41) || tokens.match(50) || tokens.match(51) || tokens.match(52) || tokens.match(53) || tokens.match(54) || tokens.match(55) || tokens.match(56) || tokens.match(57)) {
            expression = Parser.parseFunction(variables, tokens);
        } else if (tokens.match(19) || tokens.match(20) || tokens.match(22) || tokens.match(21) || tokens.match(23)) {
            expression = Parser.parseDayQuoteFunction(variables, tokens);
        } else if (tokens.match(24) || tokens.match(48) || tokens.match(49)) {
            expression = Parser.parseFlowControl(variables, tokens);
        } else if (tokens.match(0)) {
            tokens.pop();
            expression = Parser.parseSubExpression(variables, tokens);
            Parser.parseRightParenthesis(variables, tokens);
        } else if (tokens.match(101)) {
            expression = Parser.parseVariable(variables, tokens);
        } else if (tokens.match(42) || tokens.match(43) || tokens.match(44) || tokens.match(45)) {
            expression = Parser.parseDefineVariable(variables, tokens);
        } else {
            throw new ParserException(Locale.getString("UNEXPECTED_SYMBOL_ERROR"));
        }
        return var2_2;
    }

    private static Expression parseVariable(Variables variables, TokenStack tokens) throws ParserException {
        Token token = tokens.pop();
        if (!$assertionsDisabled && token.getType() != 101) {
            throw new AssertionError();
        }
        Variable variable = variables.get(token.getVariableName());
        if (variable == null) {
            throw new ParserException(Locale.getString("UNKNOWN_IDENTIFIER_ERROR", token.getVariableName()));
        }
        if (tokens.match(46)) {
            tokens.pop();
            if (variable.isConstant()) {
                throw new ParserException(Locale.getString("VARIABLE_IS_CONSTANT_ERROR", token.getVariableName()));
            }
            Expression value = Parser.parseSubExpression(variables, tokens);
            return new SetVariableExpression(token.getVariableName(), variable.getType(), value);
        }
        return new GetVariableExpression(token.getVariableName(), variable.getType());
    }

    /*
     * WARNING - void declaration
     */
    private static Expression parseDefineVariable(Variables variables, TokenStack tokens) throws ParserException {
        void var5_5;
        int type;
        Token token;
        boolean isConstant = false;
        Expression value = null;
        if (tokens.match(42)) {
            isConstant = true;
            tokens.pop();
        }
        if ((token = tokens.pop()).getType() == 43) {
            type = 0;
        } else if (token.getType() == 45) {
            type = 1;
        } else if (token.getType() == 44) {
            type = 2;
        } else {
            throw new ParserException(Locale.getString("EXPECTED_VARIABLE_TYPE_ERROR"));
        }
        token = tokens.pop();
        if (token.getType() != 101) {
            throw new ParserException(Locale.getString("ILLEGAL_VARIABLE_NAME_ERROR"));
        }
        String name = token.getVariableName();
        if (tokens.match(46)) {
            tokens.pop();
            value = Parser.parseSubExpression(variables, tokens);
        } else {
            value = new NumberExpression(0.0, (int)var5_5);
        }
        if (variables.contains(name)) {
            throw new ParserException(Locale.getString("VARIABLE_DEFINED_ERROR", name));
        }
        variables.add(name, (int)var5_5, isConstant);
        return new DefineVariableExpression(name, (int)var5_5, isConstant, value);
    }

    private static Expression parseQuote(Variables variables, TokenStack tokens) throws ParserException {
        Expression expression;
        Token quote = tokens.pop();
        switch (quote.getType()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                expression = ExpressionFactory.newExpression(quote);
                break;
            }
            default: {
                throw new ParserException(Locale.getString("EXPECTED_QUOTE_TYPE_ERROR"));
            }
        }
        return expression;
    }

    private static Expression parseString(Variables variables, TokenStack tokens) throws ParserException {
        Token string = tokens.pop();
        if (string.getType() == 102) {
            return ExpressionFactory.newExpression(string);
        }
        throw new ParserException(Locale.getString("EXPECTED_STRING_TYPE_ERROR"));
    }

    private static Expression parseNumber(Variables variables, TokenStack tokens) throws ParserException {
        Token number = tokens.pop();
        boolean negate = false;
        if (number.getType() == 32 || number.getType() == 33) {
            return ExpressionFactory.newExpression(number);
        }
        if (number.getType() == 8) {
            number = tokens.pop();
            negate = true;
        }
        if (number.getType() == 100) {
            if (negate) {
                number.negate();
            }
            return ExpressionFactory.newExpression(number);
        }
        throw new ParserException(Locale.getString("EXPECTED_NUMBER_ERROR"));
    }

    private static Expression parseFunction(Variables variables, TokenStack tokens) throws ParserException {
        Expression arg1 = null;
        Expression arg2 = null;
        Expression arg3 = null;
        Expression arg4 = null;
        Token function = tokens.pop();
        Parser.parseLeftParenthesis(variables, tokens);
        switch (function.getType()) {
            case 15: 
            case 54: {
                arg1 = Parser.parseQuote(variables, tokens);
                if (!tokens.match(1)) {
                    Parser.parseComma(variables, tokens);
                    arg2 = Parser.parseSubExpression(variables, tokens);
                    break;
                }
                arg2 = new NumberExpression(0);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 39: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                arg1 = Parser.parseQuote(variables, tokens);
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseSubExpression(variables, tokens);
                if (!tokens.match(1)) {
                    Parser.parseComma(variables, tokens);
                    arg3 = Parser.parseSubExpression(variables, tokens);
                    break;
                }
                arg3 = new NumberExpression(0);
                break;
            }
            case 31: {
                arg1 = new NumberExpression(45);
                arg2 = new NumberExpression(0);
                if (tokens.match(1)) break;
                arg1 = Parser.parseSubExpression(variables, tokens);
                if (tokens.match(1)) break;
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseSubExpression(variables, tokens);
                break;
            }
            case 50: {
                arg1 = Parser.parseString(variables, tokens);
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseQuote(variables, tokens);
                Parser.parseComma(variables, tokens);
                arg3 = Parser.parseSubExpression(variables, tokens);
                if (!tokens.match(1)) {
                    Parser.parseComma(variables, tokens);
                    arg4 = Parser.parseSubExpression(variables, tokens);
                    break;
                }
                arg4 = new NumberExpression(0);
                break;
            }
            case 51: {
                arg1 = Parser.parseQuote(variables, tokens);
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseSubExpression(variables, tokens);
                if (!tokens.match(1)) {
                    Parser.parseComma(variables, tokens);
                    arg3 = Parser.parseSubExpression(variables, tokens);
                    if (!tokens.match(1)) {
                        Parser.parseComma(variables, tokens);
                        arg4 = Parser.parseSubExpression(variables, tokens);
                        break;
                    }
                    if (arg3.getType() == 2) {
                        arg4 = new NumberExpression(0.1);
                        break;
                    }
                    arg4 = arg3;
                    arg3 = new NumberExpression(0);
                    break;
                }
                arg3 = new NumberExpression(0);
                arg4 = new NumberExpression(0.1);
                break;
            }
            case 56: {
                arg2 = new NumberExpression(0);
                arg3 = new NumberExpression(50000);
                arg1 = Parser.parseSubExpression(variables, tokens);
                if (tokens.match(1)) break;
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseSubExpression(variables, tokens);
                if (tokens.match(1)) break;
                Parser.parseComma(variables, tokens);
                arg3 = Parser.parseSubExpression(variables, tokens);
                break;
            }
            case 29: {
                arg1 = Parser.parseSubExpression(variables, tokens);
                Parser.parseComma(variables, tokens);
                arg2 = Parser.parseSubExpression(variables, tokens);
                break;
            }
            case 13: 
            case 40: 
            case 41: {
                arg1 = Parser.parseSubExpression(variables, tokens);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        Expression expression = ExpressionFactory.newExpression(function, arg1, arg2, arg3, arg4);
        Parser.parseRightParenthesis(variables, tokens);
        return expression;
    }

    private static Expression parseDayQuoteFunction(Variables variables, TokenStack tokens) throws ParserException {
        return new LagExpression(Parser.parseQuote(variables, tokens), new NumberExpression(0));
    }

    private static Expression parseFlowControl(Variables variables, TokenStack tokens) throws ParserException {
        Token token = tokens.pop();
        Parser.parseLeftParenthesis(variables, tokens);
        if (token.getType() == 24) {
            Expression condition = Parser.parseSubExpression(variables, tokens);
            Parser.parseRightParenthesis(variables, tokens);
            Expression ifTrue = Parser.parseExpression(variables, tokens);
            Parser.parseElse(variables, tokens);
            Expression ifFalse = Parser.parseExpression(variables, tokens);
            return ExpressionFactory.newExpression(token, condition, ifTrue, ifFalse);
        }
        if (token.getType() == 49) {
            Expression condition = Parser.parseSubExpression(variables, tokens);
            Parser.parseRightParenthesis(variables, tokens);
            Expression command = Parser.parseExpression(variables, tokens);
            return ExpressionFactory.newExpression(token, condition, command);
        }
        if (!$assertionsDisabled && token.getType() != 48) {
            throw new AssertionError();
        }
        Expression initial = Parser.parseSubExpression(variables, tokens);
        Parser.parseSemicolon(variables, tokens);
        Expression condition = Parser.parseSubExpression(variables, tokens);
        Parser.parseSemicolon(variables, tokens);
        Expression loop = Parser.parseSubExpression(variables, tokens);
        Parser.parseRightParenthesis(variables, tokens);
        Expression command = Parser.parseExpression(variables, tokens);
        return ExpressionFactory.newExpression(token, initial, condition, loop, command);
    }

    private static void parseComma(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(14)) {
            throw new ParserException(Locale.getString("EXPECTED_COMMA_ERROR"));
        }
    }

    private static void parseLeftParenthesis(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(0)) {
            throw new ParserException(Locale.getString("EXPECTED_LEFT_PARENTHESIS_ERROR"));
        }
    }

    private static void parseRightParenthesis(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(1)) {
            throw new ParserException(Locale.getString("MISSING_RIGHT_PARENTHESIS_ERROR"));
        }
    }

    private static void parseLeftBrace(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(25)) {
            throw new ParserException(Locale.getString("EXPECTED_LEFT_BRACE_ERROR"));
        }
    }

    private static void parseRightBrace(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(26)) {
            throw new ParserException(Locale.getString("MISSING_RIGHT_BRACE_ERROR"));
        }
    }

    private static void parseElse(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(28)) {
            throw new ParserException(Locale.getString("EXPECTED_ELSE_ERROR"));
        }
    }

    private static void parseSemicolon(Variables variables, TokenStack tokens) throws ParserException {
        if (!tokens.pop(47)) {
            throw new ParserException(Locale.getString("EXPECTED_SEMICOLON_ERROR"));
        }
    }

    static {
        $assertionsDisabled = !Parser.class.desiredAssertionStatus();
    }
}

