/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mov.parser.ParserException;
import org.mov.parser.Variables;
import org.mov.parser.expression.AbstractExpression;
import org.mov.util.Locale;

public class Token {
    public static final int LEFT_PARENTHESIS_TOKEN = 0;
    public static final int RIGHT_PARENTHESIS_TOKEN = 1;
    public static final int LESS_THAN_EQUAL_TOKEN = 2;
    public static final int GREATER_THAN_EQUAL_TOKEN = 3;
    public static final int LESS_THAN_TOKEN = 4;
    public static final int GREATER_THAN_TOKEN = 5;
    public static final int EQUAL_TOKEN = 6;
    public static final int ADD_TOKEN = 7;
    public static final int SUBTRACT_TOKEN = 8;
    public static final int MULTIPLY_TOKEN = 9;
    public static final int DIVIDE_TOKEN = 10;
    public static final int OR_TOKEN = 11;
    public static final int AND_TOKEN = 12;
    public static final int NOT_TOKEN = 13;
    public static final int COMMA_TOKEN = 14;
    public static final int LAG_TOKEN = 15;
    public static final int MIN_TOKEN = 16;
    public static final int MAX_TOKEN = 17;
    public static final int AVG_TOKEN = 18;
    public static final int DAY_OPEN_TOKEN = 19;
    public static final int DAY_CLOSE_TOKEN = 20;
    public static final int DAY_LOW_TOKEN = 21;
    public static final int DAY_HIGH_TOKEN = 22;
    public static final int DAY_VOLUME_TOKEN = 23;
    public static final int IF_TOKEN = 24;
    public static final int LEFT_BRACE_TOKEN = 25;
    public static final int RIGHT_BRACE_TOKEN = 26;
    public static final int FULLSTOP_TOKEN = 27;
    public static final int ELSE_TOKEN = 28;
    public static final int PERCENT_TOKEN = 29;
    public static final int NOT_EQUAL_TOKEN = 30;
    public static final int RSI_TOKEN = 31;
    public static final int TRUE_TOKEN = 32;
    public static final int FALSE_TOKEN = 33;
    public static final int DAY_OF_WEEK_TOKEN = 34;
    public static final int DAY_OF_YEAR_TOKEN = 35;
    public static final int DAY_TOKEN = 36;
    public static final int MONTH_TOKEN = 37;
    public static final int YEAR_TOKEN = 38;
    public static final int SUM_TOKEN = 39;
    public static final int SQRT_TOKEN = 40;
    public static final int ABS_TOKEN = 41;
    public static final int CONSTANT_TOKEN = 42;
    public static final int BOOLEAN_TOKEN = 43;
    public static final int INTEGER_TOKEN = 44;
    public static final int FLOAT_TOKEN = 45;
    public static final int SET_TOKEN = 46;
    public static final int SEMICOLON_TOKEN = 47;
    public static final int FOR_TOKEN = 48;
    public static final int WHILE_TOKEN = 49;
    public static final int CORR_TOKEN = 50;
    public static final int EMA_TOKEN = 51;
    public static final int BBL_TOKEN = 52;
    public static final int BBU_TOKEN = 53;
    public static final int MACD_TOKEN = 54;
    public static final int MOMENTUM_TOKEN = 55;
    public static final int OBV_TOKEN = 56;
    public static final int SD_TOKEN = 57;
    private static final int FIXED_LENGTH_TOKENS = 58;
    public static final int NUMBER_TOKEN = 100;
    public static final int VARIABLE_TOKEN = 101;
    public static final int STRING_TOKEN = 102;
    private int type = 0;
    private double value = 0.0;
    private String variableName = null;
    private int valueType = 0;
    private String stringValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringToToken(Variables variables, Token token, String string) throws ParserException {
        String[] tokenStrings = new String[]{"(", ")", "<=", ">=", "<", ">", "==", "+", "-", "*", "/", "or", "and", "not", ",", "lag", "min", "max", "avg", "open", "close", "low", "high", "volume", "if", "{", "}", ".", "else", "percent", "!=", "rsi", "true", "false", "dayofweek", "dayofyear", "day", "month", "year", "sum", "sqrt", "abs", "const", "boolean", "int", "float", "=", ";", "for", "while", "corr", "ema", "bol_lower", "bol_upper", "macd", "momentum", "obv", "sd"};
        boolean matched = false;
        if (Character.isDigit(string.charAt(0))) {
            double value = 0.0;
            String numberString = new String();
            int valueType = 2;
            do {
                if (string.charAt(0) == '.') {
                    valueType = 1;
                }
                numberString = numberString.concat(string.substring(0, 1));
            } while ((string = string.substring(1)).length() > 0 && (Character.isDigit(string.charAt(0)) || string.charAt(0) == '.'));
            try {
                value = AbstractExpression.parseDouble(numberString);
            }
            catch (NumberFormatException e) {
                throw new ParserException(Locale.getString("MALFORMED_NUMBER_ERROR"));
            }
            token.setType(100);
            token.setValue(value);
            token.setValueType(valueType);
            matched = true;
        } else if (string.charAt(0) == '\"') {
            int closingQuote = string.indexOf(34, 1);
            if (closingQuote < 0) throw new ParserException(Locale.getString("MISSING_CLOSING_QUOTE"));
            String quote = string.substring(1, closingQuote);
            string = string.substring(closingQuote + 1);
            token.setType(102);
            token.setStringValue(quote);
            matched = true;
        } else if (Character.isLetter(string.charAt(0))) {
            Pattern pattern = Pattern.compile("^[a-zA-Z0-9_]*");
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            String identifier = matcher.group();
            for (int i = 0; !matched && i < tokenStrings.length; ++i) {
                if (!identifier.equals(tokenStrings[i])) continue;
                token.setType(i);
                string = string.substring(tokenStrings[i].length());
                matched = true;
            }
            if (!matched && (matcher = (pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*")).matcher(string)).find()) {
                String variableName = matcher.group();
                string = string.substring(variableName.length());
                matched = true;
                token.setType(101);
                token.setVariableName(variableName);
            }
            if (!matched) {
                throw new ParserException(Locale.getString("UNKNOWN_IDENTIFIER_ERROR", identifier));
            }
        } else {
            char symbol = string.charAt(0);
            for (int i = 0; !matched && i < tokenStrings.length; ++i) {
                if (!string.startsWith(tokenStrings[i])) continue;
                token.setType(i);
                string = string.substring(tokenStrings[i].length());
                matched = true;
            }
            if (!matched) {
                throw new ParserException(Locale.getString("UNKNOWN_SYMBOL_ERROR", symbol));
            }
        }
        if ($assertionsDisabled || matched) return string;
        throw new AssertionError();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getValue() {
        if (!$assertionsDisabled && this.getType() != 100) {
            throw new AssertionError();
        }
        return this.value;
    }

    public String getStringValue() {
        if (!$assertionsDisabled && this.getType() != 102) {
            throw new AssertionError();
        }
        return this.stringValue;
    }

    public String getVariableName() {
        if (!$assertionsDisabled && this.getType() != 101) {
            throw new AssertionError();
        }
        return this.variableName;
    }

    public int getValueType() {
        if (!$assertionsDisabled && this.getType() != 100) {
            throw new AssertionError();
        }
        return this.valueType;
    }

    public void negate() {
        if (!$assertionsDisabled && this.getType() != 100) {
            throw new AssertionError();
        }
        this.value = -this.value;
    }

    private void setVariableName(String variableName) {
        if (!$assertionsDisabled && this.getType() != 101) {
            throw new AssertionError();
        }
        this.variableName = variableName;
    }

    private void setValueType(int valueType) {
        this.valueType = valueType;
    }

    private void setValue(double value) {
        if (!$assertionsDisabled && this.getType() != 100) {
            throw new AssertionError();
        }
        this.value = value;
    }

    private void setStringValue(String stringValue) {
        if (!$assertionsDisabled && this.getType() != 102) {
            throw new AssertionError();
        }
        this.stringValue = stringValue;
    }

    static {
        $assertionsDisabled = !Token.class.desiredAssertionStatus();
    }
}

