/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.mov.parser.Expression;

public abstract class AbstractExpression
implements Expression {
    private static final String format = "0.000000#";
    private static final DecimalFormat decimalFormat;
    private Expression parent = null;
    private Expression[] children;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractExpression() {
        this.children = new Expression[this.getChildCount()];
    }

    public AbstractExpression(int childCount) {
        this.children = new Expression[childCount];
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setParent(Expression parent) {
        if (!$assertionsDisabled && parent == this) {
            throw new AssertionError();
        }
        this.parent = parent;
    }

    public Expression getChild(int index) {
        if (!$assertionsDisabled && index > this.getChildCount()) {
            throw new AssertionError();
        }
        return this.children[index];
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void setChild(Expression child, int index) {
        if (!$assertionsDisabled && index > this.getChildCount()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child == this) {
            throw new AssertionError();
        }
        if (child != null && child.getParent() != null) {
            Expression oldParent = child.getParent();
            oldParent.setChild(null, oldParent.getIndex(child));
        }
        if (this.getChild(index) != null) {
            this.getChild(index).setParent(null);
        }
        if (child != null) {
            child.setParent(this);
        }
        this.children[index] = child;
    }

    public Expression simplify() {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.setChild(this.getChild(i).simplify(), i);
            }
        }
        return this;
    }

    public int getIndex(Expression child) {
        for (int index = 0; index < this.getChildCount(); ++index) {
            if (this.getChild(index) != child) continue;
            return index;
        }
        return -1;
    }

    public static double parseDouble(String doubleText) throws NumberFormatException {
        double retValue = 0.0;
        try {
            Number num = decimalFormat.parse(doubleText);
            if (num == null) {
                throw new ParseException("AbstractExpression - parseDouble - null Error", 0);
            }
            retValue = decimalFormat.parse(doubleText).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException();
        }
        return retValue;
    }

    public static int parseInt(String intText) throws NumberFormatException {
        int retValue = 0;
        try {
            Number num = decimalFormat.parse(intText);
            if (num == null) {
                throw new ParseException("AbstractExpression - parseInt - null Error", 0);
            }
            retValue = decimalFormat.parse(intText).intValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException();
        }
        return retValue;
    }

    public static Double valueOfDouble(String doubleText) throws NumberFormatException {
        Double retValue = null;
        try {
            Number num = decimalFormat.parse(doubleText);
            if (num == null) {
                throw new ParseException("AbstractExpression - valueOfDouble - null Error", 0);
            }
            retValue = new Double(decimalFormat.parse(doubleText).doubleValue());
        }
        catch (ParseException e) {
            throw new NumberFormatException();
        }
        return retValue;
    }

    public static Integer valueOfInt(String intText) throws NumberFormatException {
        Integer retValue = null;
        try {
            Number num = decimalFormat.parse(intText);
            if (num == null) {
                throw new ParseException("AbstractExpression - valueOfInt - null Error", 0);
            }
            retValue = new Integer(decimalFormat.parse(intText).intValue());
        }
        catch (ParseException e) {
            throw new NumberFormatException();
        }
        return retValue;
    }

    public static NumberFormat getNumberFormat() {
        NumberFormat format = null;
        format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setGroupingUsed(false);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(6);
        return format;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Expression)) {
            return false;
        }
        Expression expression = (Expression)object;
        if (this.getClass() != expression.getClass()) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (((Object)this.getChild(i)).equals(expression.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public int size() {
        int count = 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Expression child = this.getChild(i);
            count += child.size();
        }
        return count;
    }

    public int size(int type) {
        int count = 0;
        if (!$assertionsDisabled && type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5) {
            throw new AssertionError();
        }
        if (this.getType() == type) {
            count = 1;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Expression child = this.getChild(i);
            count += child.size(type);
        }
        return count;
    }

    public Iterator iterator() {
        ArrayList list = new ArrayList();
        this.buildIterationList(list, this);
        return list.iterator();
    }

    private void buildIterationList(List list, Expression expression) {
        list.add(expression);
        for (int i = 0; i < expression.getChildCount(); ++i) {
            this.buildIterationList(list, expression.getChild(i));
        }
    }

    public abstract Object clone();

    static {
        $assertionsDisabled = !AbstractExpression.class.desiredAssertionStatus();
        decimalFormat = new DecimalFormat(format, new DecimalFormatSymbols(Locale.ENGLISH));
    }
}

