/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.expression.BinaryExpression;
import org.mov.parser.expression.NumberExpression;

public abstract class ArithmeticExpression
extends BinaryExpression {
    public ArithmeticExpression(Expression left, Expression right) {
        super(left, right);
    }

    public int checkType() throws TypeMismatchException {
        int leftType = this.getChild(0).checkType();
        int rightType = this.getChild(1).checkType();
        if (!(leftType != 1 && leftType != 2 || rightType != 1 && rightType != 2)) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public Expression simplify() {
        super.simplify();
        if (this.getChild(0) instanceof NumberExpression && this.getChild(1) instanceof NumberExpression) {
            try {
                return new NumberExpression(this.evaluate(null, null, null, 0), this.getType());
            }
            catch (EvaluationException e) {
                return this;
            }
        }
        return this;
    }

    public int getType() {
        return this.getChild(0).getType();
    }
}

