/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import java.util.ArrayList;
import java.util.List;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.AbstractExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class ClauseExpression
extends AbstractExpression {
    private int childCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClauseExpression(List children) {
        super(children.size());
        this.childCount = children.size();
        if (!$assertionsDisabled && this.childCount <= 0) {
            throw new AssertionError();
        }
        for (int child = 0; child < this.getChildCount(); ++child) {
            this.setChild((Expression)children.get(child), child);
        }
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        double value = 0.0;
        Variables tmpVar = null;
        try {
            tmpVar = (Variables)variables.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        for (int child = 0; child < this.getChildCount(); ++child) {
            value = this.getChild(child).evaluate(tmpVar, quoteBundle, symbol, day);
        }
        return value;
    }

    public static String toString(Expression expression) {
        if (expression instanceof ClauseExpression && expression.getChildCount() != 1) {
            return " " + expression + " ";
        }
        return "\n   " + expression + "\n";
    }

    public String toString() {
        String string;
        if (this.getChildCount() == 1) {
            string = ((Object)this.getChild(0)).toString();
        } else {
            string = "{\n";
            for (int child = 0; child < this.getChildCount(); ++child) {
                string = string.concat("   ");
                string = string.concat(((Object)this.getChild(child)).toString());
                string = string.concat("\n");
            }
            string = string.concat("}\n");
        }
        return string;
    }

    public int checkType() throws TypeMismatchException {
        int type = 2;
        for (int child = 0; child < this.getChildCount(); ++child) {
            type = this.getChild(child).checkType();
        }
        return type;
    }

    public int getType() {
        return this.getChild(this.getChildCount() - 1).getType();
    }

    public int getChildCount() {
        return this.childCount;
    }

    public Object clone() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int child = 0; child < this.getChildCount(); ++child) {
            expressions.add(this.getChild(child));
        }
        return new ClauseExpression(expressions);
    }

    static {
        $assertionsDisabled = !ClauseExpression.class.desiredAssertionStatus();
    }
}

