/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.QuaternaryExpression;
import org.mov.parser.expression.QuoteExpression;
import org.mov.parser.expression.StringExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleFunctionSource;
import org.mov.quote.QuoteFunctions;
import org.mov.quote.Symbol;
import org.mov.quote.SymbolFormatException;

public class CorrExpression
extends QuaternaryExpression {
    public CorrExpression(Expression symbol, Expression quote, Expression days, Expression lag) {
        super(symbol, quote, days, lag);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        Symbol correlatedSymbol;
        String correlatedSymbolString = ((StringExpression)this.getChild(0)).getText();
        int quoteKind = ((QuoteExpression)this.getChild(1)).getQuoteKind();
        int period = (int)this.getChild(2).evaluate(variables, quoteBundle, symbol, day);
        if (period <= 1) {
            throw EvaluationException.CORR_RANGE_EXCEPTION;
        }
        int offset = (int)this.getChild(3).evaluate(variables, quoteBundle, symbol, day);
        if (offset > 0) {
            throw EvaluationException.CORR_OFFSET_EXCEPTION;
        }
        try {
            correlatedSymbol = Symbol.find(correlatedSymbolString);
        }
        catch (SymbolFormatException e) {
            throw new EvaluationException(e.getMessage());
        }
        QuoteBundleFunctionSource source = new QuoteBundleFunctionSource(quoteBundle, symbol, quoteKind, day, offset, period);
        QuoteBundleFunctionSource correlatedSource = new QuoteBundleFunctionSource(quoteBundle, correlatedSymbol, quoteKind, day, offset, period);
        return QuoteFunctions.corr(source, correlatedSource, period);
    }

    public String toString() {
        return new String("corr(" + ((Object)this.getChild(0)).toString() + ", " + ((Object)this.getChild(1)).toString() + ", " + ((Object)this.getChild(2)).toString() + ", " + ((Object)this.getChild(3)).toString() + ")");
    }

    public int checkType() throws TypeMismatchException {
        if (this.getChild(0).checkType() == 5 && (this.getChild(1).checkType() == 3 || this.getChild(1).checkType() == 4) && this.getChild(2).checkType() == 2 && this.getChild(3).checkType() == 2) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public int getType() {
        return 1;
    }

    public Object clone() {
        return new CorrExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone(), (Expression)this.getChild(2).clone(), (Expression)this.getChild(3).clone());
    }
}

