/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.parser.expression.UnaryExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Locale;

public class DefineVariableExpression
extends UnaryExpression {
    private String name;
    private int type;
    private boolean isConstant;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefineVariableExpression(String name, int type, boolean isConstant, Expression value) {
        super(value);
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        this.name = name;
        this.type = type;
        this.isConstant = isConstant;
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        double value = this.getChild(0).evaluate(variables, quoteBundle, symbol, day);
        if (!variables.contains(this.getName())) {
            variables.add(this.getName(), this.getType(), this.isConstant(), value);
            return value;
        }
        throw new EvaluationException(Locale.getString("VARIABLE_DEFINED_ERROR", this.getName()));
    }

    public String toString() {
        String string = "";
        if (this.isConstant()) {
            string = string.concat("const ");
        }
        switch (this.getType()) {
            case 0: {
                string = string.concat("boolean");
            }
            case 2: {
                string = string.concat("int");
            }
        }
        if (!$assertionsDisabled && this.getType() != 1) {
            throw new AssertionError();
        }
        string = string.concat("float");
        string = string.concat(" ");
        string = string.concat(this.name);
        string = string.concat(" = ");
        string = string.concat(((Object)this.getChild(0)).toString());
        return string;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public int checkType() throws TypeMismatchException {
        if (this.getType() == this.getChild(0).checkType()) {
            return this.getType();
        }
        throw new TypeMismatchException();
    }

    public boolean equals(Object object) {
        DefineVariableExpression expression;
        return object instanceof DefineVariableExpression && (expression = (DefineVariableExpression)object).getName().equals(this.getName()) && expression.getType() == this.getType() && expression.isConstant() == this.isConstant() && ((Object)expression.getChild(0)).equals(this.getChild(0));
    }

    public Object clone() {
        return new DefineVariableExpression(this.getName(), this.getType(), this.isConstant(), (Expression)this.getChild(0).clone());
    }

    static {
        $assertionsDisabled = !DefineVariableExpression.class.desiredAssertionStatus();
    }
}

