/*
 * Decompiled with CFR 0.152.
 */
package org.mov.parser.expression;

import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.parser.expression.ArithmeticExpression;
import org.mov.parser.expression.NumberExpression;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class DivideExpression
extends ArithmeticExpression {
    public DivideExpression(Expression left, Expression right) {
        super(left, right);
    }

    public double evaluate(Variables variables, QuoteBundle quoteBundle, Symbol symbol, int day) throws EvaluationException {
        double right = this.getChild(1).evaluate(variables, quoteBundle, symbol, day);
        if (right != 0.0) {
            return this.getChild(0).evaluate(variables, quoteBundle, symbol, day) / right;
        }
        throw EvaluationException.DIVIDE_BY_ZERO_EXCEPTION;
    }

    public Expression simplify() {
        Expression simplified = super.simplify();
        if (simplified == this) {
            NumberExpression right;
            NumberExpression left = this.getChild(0) instanceof NumberExpression ? (NumberExpression)this.getChild(0) : null;
            NumberExpression numberExpression = right = this.getChild(1) instanceof NumberExpression ? (NumberExpression)this.getChild(1) : null;
            if (left != null && left.equals(0.0)) {
                return new NumberExpression(0.0, this.getType());
            }
            if (right != null && right.equals(1.0)) {
                return this.getChild(0);
            }
            if (((Object)this.getChild(0)).equals(this.getChild(1))) {
                return new NumberExpression(1.0, this.getType());
            }
        }
        return simplified;
    }

    public String toString() {
        return super.toString("/");
    }

    public Object clone() {
        return new DivideExpression((Expression)this.getChild(0).clone(), (Expression)this.getChild(1).clone());
    }
}

